package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppPermissionDO;
import cn.com.duiba.service.domain.dataobject.PermissionDO;

import java.util.List;

public interface RemoteAppPermissionService {

	public List<PermissionDO> findAllPermission(Long appId);
	
	public void updateByAppIdAndPermissionId(Long appId, Long permissionId, Boolean enable);
	
	public Integer hasItem(Long appId, Long permissionId);

	public Integer updateEnableByAppIdAndActivityIdAndType(Long activityId, Integer type, Boolean enable);
	
	public void insert(AppPermissionDO appPermissionDO);
	
	/**
	 * 用于查询兑吧活动专用的兑换项授权是否存在
	 */
	public AppPermissionDO find4DuibaShowcase(Long appId, Long permissionId);
	
	/**
	 * 用于查询兑吧活动专用的兑换项是否授权可用
	 */
	public AppPermissionDO find4DuibaShowcaseEnable(Long appId, Long permissionId);
	
	/**
	 * 启用权限
	 */
	public int enable4DuibaShowcase(Long id);

	/**
	 * 禁用权限
	 */
	public int disable4CancelDuibaShowcase(Long id);
}
