package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.dataobject.DuibaActivityDO;
import cn.com.duiba.service.item.domain.vo.AddActivityVO;

import java.util.List;
import java.util.Map;

public interface RemoteDuibaActivityService {
	
	public int updateAutoOffDateNull(Long id);

	/**
	 * @Title: findPage
	 * @Description: 分页列表
	 * @param queryMap
	 * @return
	 */
	public List<DuibaActivityDO> findPage(Map<String, Object> queryMap);
	
	public List<DuibaActivityDO> findDuibaActivity(Map<String, Object> queryMap);
	
	/**
	 * @Title: findPageCount
	 * @Description: 分页列表总个数
	 * @param queryMap
	 * @return
	 */
	public Integer findPageCount(Map<String, Object> queryMap);

	
	/**
	 * @Title: findPageCount
	 * @Description: 分页列表总个数
	 * @param queryMap
	 * @return
	 */
	
	public Integer getCountDuibaActivity(Map<String, Object> queryMap);
	/**
	 * 获取所有开启和关闭的 活动
	 * 
	 * @param appId
	 * @return
	 */
	public List<AddActivityVO> findAllDuibaActivity(Long appId);

	/**
	 * 根据ID in
	 */
	public List<DuibaActivityDO> findAllByIds(List<Long> ids);
	
	public DuibaActivityDO find(Long id);
	
	public DuibaActivityDO insert(DuibaActivityDO duibaActivityDO);
	
	public void update(DuibaActivityDO duibaActivityDO);
	
	public List<DuibaActivityDO> findAutoOff();

	/**
	 * 后台关闭并且下架专题活动
	 */
	public DuibaActivityDO closeAndUnViewDuibaActivity(Long id);

	/**
	 * 添加活动到开发者运营活动,这个方法手机端在用
	 */
	public Long addDuibaActivityToDeveloper(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 添加活动到开发者运营活动,这个方法manager端在用
	 */
	public Long addDuibaActivityToDeveloper_manager(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 添加活动到开发者运营活动,这个方法developer端在用
	 */
	public Long addDuibaActivityToDeveloper_developer(Long appId, Long duibaActivityId, String isPreview) throws BusinessException;

	/**
	 * 获取最小积分
	 */
	public Long getDuibaActivityCredits(List<Long> itemIds, Long appId);

	/**
	 * 把所有item推送到app入口
	 */
	public void doMainPushAppItem(Long aid, ItemDO item);

	/**
	 * 把所有item更新推送到app入口
	 */
	public void doUpdateMainPushAppItem(Long appItemId, ItemDO item);

	/**
	 * 添加定向分配到定向表
	 * @param id
	 * @param appIds
	 */
	public void addDuibaActivityAppSpecify(Long id, String[] appIds);

	/**
	 * 后台创建兑吧专题活动-创建权限
	 */
	public void createDuibaActivity(DuibaActivityDO duibaActivity);

	/**
	 * 后台更新兑吧专题活动-更新权限
	 */
	public void updateDuibaActivity(DuibaActivityDO duibaActivity);

	/**
	 * 后台开启专题活动
	 */
	public void startupDuibaActivity(Long id);

	/**
	 * 后台关闭专题活动
	 */
	public DuibaActivityDO closeDuibaActivityNoTransaction(Long id);

	/**
	 * 后台删除专题活动
	 */
	public DuibaActivityDO deleteDuibaActivity(Long id);
	
}
