package cn.com.duiba.service.remoteservice;

import java.util.Date;
import java.util.List;

import cn.com.duiba.service.domain.vo.DeveloperActivityStatisticsVO;
import cn.com.duiba.service.domain.vo.OdpsActivityDailyStatVO;

/**
 * 每日活动统计
 */
public interface RemoteOdpsActivityDailyStatService {

	/**
	 * 根据appId和开始日期，结束日期，查询
	 */
	public List<OdpsActivityDailyStatVO> findSumByAppIdAndDayAndOrderBy(Long appId, Date startDay, Date endDay,String orderBy);
	
	public List<OdpsActivityDailyStatVO> findActivityDailyStatByIdAndType(Long relationId, Integer relationType, Integer offset, Integer max);
    
    public Long findActivityDailyStatByIdAndTypeCount(Long relationId, Integer relationType);

	/**
	 * 根据appId和开始日期，结束日期，查询
	 */
	public List<OdpsActivityDailyStatVO> findSumByAppIdAndDayBetween(Long appId, Date startDay, Date endDay);

	/**
	 * 根据运营活动ids查询
	 */
	public List<DeveloperActivityStatisticsVO> findAllByOperatingActivityIds(List<Long> activityIds);
}
