package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.domain.dataobject.TurntableOptionsDO;

import java.util.List;

public interface RemoteTurntableOptionsService {

	//下面这些方法来自TurntableSimpleDAO

	/**
	 * 根据奖项位置序号查询幸运转盘奖项
	 */
	public TurntableOptionsDO findByPointer(Long activityId, Integer pointer, Integer type);

	/**
	 * 根据id查询幸运转盘奖项
	 */
	public TurntableOptionsDO findOptionById(Long id);

	/**
	 * 根据奖项ID，和序号查询
	 */
	public TurntableOptionsDO findByIdAndNum(Long id, Integer num);

	/**
	 * 根据活动ID, 活动类型, 统计奖项数量
	 */
	public Integer countByTruntableId(Long turntableId, Integer activityType);

	/**
	 * 根据活动ID, 活动类型, 奖项位置 查询奖项信息
	 */
	public TurntableOptionsDO findByTurntableIdAndNum(Long turntableId, Integer num, Integer activityType);

	/**
	 * 根据活动ID, 活动类型 查询奖项集合
	 */
	public List<TurntableOptionsDO> findAllByOperatingActivityId(Long OperatingActivityId, Integer activityType);

	//下面这些方法来自TurntableTextChangeDAO


	/**
	 * 奖项库存减一
	 */
	public int reduceRemaining(Long id);

	/**
	 * 奖项库存加一
	 */
	public int addRemaining(Long id);

	/**
	 * 修改幸运转盘奖项
	 */
	public int updateTurntableOption(TurntableOptionsDO turntableOptionsDO) throws BusinessException;

	/**
	 * 添加开发者大转盘奖项
	 */
	public TurntableOptionsDO insertTurntableOption(TurntableOptionsDO turntableOptionsDO) throws BusinessException;

	//下面这些方法来自TurntableOptionsStatusChangeDAOImpl


	/**
	 * 根据ID新增库存
	 */
	public int addRemainingById(Long id, Integer addRemaining);

	/**
	 * 根据ID减少库存
	 */
	public int subRemainingById(Long id, Integer subRemaining);

	/**
	 * 根据ID更新库存
	 */
	public int updateRemainingById(Long id, Integer remaining);

	//from TurntableService in developer
	/**
	 * 根据大转盘活动ID,查询对应8个配置的抽奖项
	 *
	 * @return
	 */
	public List<TurntableOptionsDO> findOptionsByTurntableIdAndNum(Long turntableId, Integer type);

}
