package cn.com.duiba.service.domain.dataobject;

import java.util.Date;

import cn.com.duiba.service.domain.BaseDO;

public class DeveloperBlackDO extends BaseDO {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4157710016515556739L;
	public static final int TypeDuibaActivity = 0; //专题活动
	public static final int TypeTurnTable = 1; // 大转盘活动
	public static final int TypeDuibaSingleLottery = 2; // 兑吧单品抽奖
	public static final int TypeAppSingleLottery = 3; // App自有单品抽奖
	public static final int TypeDuibaTurntable = 4; //兑吧大转盘
	public static final int TypeAppManualLottery = 5; //app自有手动开奖
	public static final int TypeShakeLottery = 6;//摇一摇
	public static final int TypeScratchCard = 7;//刮刮卡
	public static final int TypeHdToolTurntable = 8;//活动工具大转盘
	public static final int TypeHdToolTiger = 9;//老虎机
	public static final int TypeItem = 10;//兑换项
	public static final int TypeSecondsKill = 30;//周三必抢（秒杀专题）
	public static final int TypeGameSanta = 20;//游戏活动-打劫圣诞老人
	public static final int TypeGameYearAward = 21;//游戏活动-数年终奖
	public static final int TypeGameGirl = 22;//游戏活动-女神pk女汉子
	public static final int TypeGameJiong = 23;//游戏活动-人在囧途
	
	public static final int TypeDuibaQuestionAnswer = 40;	// 兑吧答题
	public static final int TypeDuibaQuizz = 41;	// 兑吧测试题
	public static final int TypeDuibaSeckill = 31;	// 兑吧秒杀活动
	
	/**
	 * 兑吧-普通活动工具
	 */
	public static final int TYPE_SHAKE = 1;//摇一摇抽奖
	public static final int TYPE_SCRATCH = 2;//刮刮乐
	public static final int TYPE_TURNTABLE = 3;//大转盘
	public static final int TYPE_TIGER = 4;//老虎机
	
	/**
	 * 兑吧-游戏
	 */
	public static final int TYPE_SANTA = 1;// 打劫圣诞老人
	public static final int TYPE_YEAR_AWARD = 2;// 数年终奖
	public static final int TYPE_GIRL = 3;//女神PK女汉子游戏
	public static final int TYPE_JIONG = 4;
	
	private Long id;
	private Long activityId;  //活动id
	private Long developerId; //开发者id
	private Integer activityType;//1:专题活动,2:单品抽奖,3:幸运转盘,4:活动工具,5:游戏,6:秒杀专题,7:答题,8:测试题,9:秒杀活动
	private Date create;
	private Date modified;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public Long getDeveloperId() {
		return developerId;
	}

	public void setDeveloperId(Long developerId) {
		this.developerId = developerId;
	}

	public Integer getActivityType() {
		return activityType;
	}

	public void setActivityType(Integer activityType) {
		this.activityType = activityType;
	}

	public Date getCreate() {
		return create;
	}

	public void setCreate(Date create) {
		this.create = create;
	}

	public Date getModified() {
		return modified;
	}

	public void setModified(Date modified) {
		this.modified = modified;
	}
	
	/**
	 * 判断是否是游戏活动
	 * @return
	 */
	public boolean isGame(){
		if(this.activityType == TypeGameSanta
				|| this.activityType == TypeGameYearAward
			 	|| this.activityType == TypeGameGirl
			 	|| this.activityType == TypeGameJiong)
			return true;
		else return false;
	}
	
	/**
	 * 判断是否是活动工具
	 * @return
	 */
	public boolean isHdTool(){
		if(this.activityType == TypeShakeLottery
				|| this.activityType == TypeScratchCard
			 	|| this.activityType == TypeHdToolTiger
			 	|| this.activityType == TypeHdToolTurntable)
			return true;
		else return false;
	}
	
	public static int getHdToolTypeByDuibaType(int duibaType){
		if(duibaType == 1){
           return TypeShakeLottery;
        }else if(duibaType ==2){
        	return TypeScratchCard;
        }else if(duibaType == 3){
            return TypeHdToolTurntable;
        }else if(duibaType == 4){
            return TypeHdToolTiger;
        }
		return -1;
	}
	
	public static int getGameTypeByDuibaType(int duibaType){
		if(duibaType == 1){
           return TypeGameSanta;
        }else if(duibaType ==2){
        	return TypeGameYearAward;
        }else if(duibaType == 3){
            return TypeGameGirl;
        }else if(duibaType == 4){
            return TypeGameJiong;
        }
		return -1;
	}

	@Override
	public String toString() {
		return "DeveloperBlackDO [id=" + id + ", activityId=" + activityId
				+ ", developerId=" + developerId + ", activityType="
				+ activityType + ", create=" + create + ", modified="
				+ modified + "]";
	}
	
}
