package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DeveloperBlacklistDO;
import cn.com.duiba.service.domain.vo.DevVO;
import cn.com.duiba.service.domain.vo.PaginationVO;

import java.util.List;
import java.util.Map;

public interface RemoteDeveloperBlacklistService {

	public void delete(Long id);

	public DeveloperBlacklistDO findByDeveloperId(Long developerId);

	public PaginationVO<DeveloperBlacklistDO> findPage(Map<String, Object> queryMap);

	/**
	 * 开发者黑名单待选列表
	 */
	public List<DevVO> findDevVO(String queryInfo);

	/**
	 * 把开发者添加到黑名单中
	 */
	public void addDevIntoBlacklist(Long[] devIds);

	/**
	 * 获取所有在开发者黑名单中的appIds
	 */
	public List<Long> getAllBlackAppIds();

	public List<DeveloperBlacklistDO> findAll();
}
