package cn.com.duiba.service.remoteservice;

import java.util.List;

import cn.com.duiba.service.domain.dataobject.OdpsAppDailyReportDO;

public interface RemoteOdpsAppDailyReportService {
	/**
	 * 根据App和时间区间查询
	 * @param appId
	 * @param start
	 * @param end
	 * @return
	 */
	public List<OdpsAppDailyReportDO> findAppDailyReportByAppIdAndDay(Long appId, String start, String end);
	
	
	/**
	 * 查询月数据
	 * @param appId
	 * @param month
	 * @return
	 */
	public List<OdpsAppDailyReportDO> findAppDailyReportByMonth(Long appId,String month);
	
	
	/**
	 * 查询月数据
	 * @param appId
	 * @param month
	 * @return
	 */
	public OdpsAppDailyReportDO findSumAppDailyReportByMonth(Long appId,String month);
	
	
	/**
	 * 根据App和时间区间查询
	 * @param appId
	 * @param start
	 * @param end
	 * @return
	 */
	public OdpsAppDailyReportDO findByAppIdAndDay(Long appId, String searchDate);
	
	
}
