package cn.com.duiba.service.item.domain.dataobject;

import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

public class ItemStockManualChangeDO extends BaseDO{
	private static final long serialVersionUID = 416121L;

	public static final String TYPE_DUIBA_ITEM = "item";
	public static final String TYPE_DEV_ITEM = "appItem";
	public static final String KIND_ADD = "add";
	public static final String KIND_SUB = "sub";
	
	private Long id;
	private Long relationId;
	private String relationType;
	private String changeKind;
	private Long changeQuantity;
	private Long beforeStock;
	private Long afterStock;
	private Date gmtCreate;
	private Date gmtModified;
	
	public ItemStockManualChangeDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public ItemStockManualChangeDO() {
	}

	public ItemStockManualChangeDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getRelationId() {
		return relationId;
	}
	public void setRelationId(Long relationId) {
		this.relationId = relationId;
	}
	public String getRelationType() {
		return relationType;
	}
	public void setRelationType(String relationType) {
		this.relationType = relationType;
	}
	public String getChangeKind() {
		return changeKind;
	}
	public void setChangeKind(String changeKind) {
		this.changeKind = changeKind;
	}
	public Long getChangeQuantity() {
		return changeQuantity;
	}
	public void setChangeQuantity(Long changeQuantity) {
		this.changeQuantity = changeQuantity;
	}
	public Long getBeforeStock() {
		return beforeStock;
	}
	public void setBeforeStock(Long beforeStock) {
		this.beforeStock = beforeStock;
	}
	public Long getAfterStock() {
		return afterStock;
	}
	public void setAfterStock(Long afterStock) {
		this.afterStock = afterStock;
	}
	public Date getGmtCreate() {
		return gmtCreate;
	}
	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}
	public Date getGmtModified() {
		return gmtModified;
	}
	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
	
}
