package cn.com.duiba.service.item.domain.vo;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.EmbedDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.tools.SeckillDomainConstant;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;

public class ItemKeyVO implements Serializable {

	private static final long serialVersionUID = 5465809480099328804L;
	public static Integer STATUS_USED = 1;     //已兑
	public static Integer STATUS_NOREMAING = 2; //兑完
	public static Integer STATUS_LOTTERY = 3;//抽奖
	public static Integer MARK_NORMAL = 0;//普通
	public static Integer MARK_TIME = 1;//秒杀
	public static Integer MARK_QUANTITY = 2;//限量
	public static Integer MARK_LOTTERY = 3;//抽奖
	public static Integer MARK_ACTIVITY = 4;//活动(专题)
	public static Integer MARK_NEW = 5;//NEW(新商品)
	public static Integer MARK_ADDRLIMIT =6;//地域限制
	public static Integer MARK_GAME =7;//游戏
	public static Integer MARK_QUESTION =8;//答题
	public static Integer MARK_QUIZZ = 9;//测试题
	public static Integer MARK_NGAME =7;//游戏
	public static Integer MARK_GUESS =10;//竞猜
	
	private ItemKey itemKey;
	
	private Integer useStatus=0;
	private Integer markStatus=MARK_NORMAL;
	private Integer payload;
	private String info;
	private String info_type;

	public String getInfo() {
		return info;
	}
	public void setInfo(String info) {
		this.info = info;
	}
	public String getInfo_type() {
		return info_type;
	}
	public void setInfo_type(String info_type) {
		this.info_type = info_type;
	}
	public ItemKeyVO(){}
	public ItemKeyVO(ItemKey itemKey){
		this.itemKey=itemKey;
	}
	
	public Long getItemId(){
		if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
			return itemKey.getItem().getId();
		}
		if (itemKey.isSelfAppItemMode()) {
			return null;
		}
		return null;
	}
	
	public Long getAppItemId(){
		if (itemKey.isItemMode()) {
			return null;
		}
		if (itemKey.isSelfAppItemMode() || itemKey.isDuibaAppItemMode()) {
			return itemKey.getAppItem().getId();
		}
		return null;
	}
	
	public String getLogo(){
		if (itemKey.isItemMode()) {
			return itemKey.getItem().getLogo();
		}
		if (itemKey.isSelfAppItemMode()) {
			return itemKey.getAppItem().getLogo();
		}
		if (itemKey.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKey.getAppItem().getLogo())) {
				return itemKey.getAppItem().getLogo();
			} else {
				return itemKey.getItem().getLogo();
			}
		}
		return null;
	}

	public String getSmallImage(){
		if (itemKey.isItemMode()) {
			return itemKey.getItem().getSmallImage();
		}
		if (itemKey.isSelfAppItemMode()) {
			return itemKey.getAppItem().getSmallImage();
		}
		if (itemKey.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKey.getAppItem().getSmallImage())) {
				return itemKey.getAppItem().getSmallImage();
			} else {
				return itemKey.getItem().getSmallImage();
			}
		}
		return null;
	}
	
	public String getImage(){
		if (itemKey.isItemMode()) {
			if(StringUtils.isNotBlank(itemKey.getItem().getMultiImage())){
				return itemKey.getItem().getMultiImage();
			}else{
				return itemKey.getItem().getImage();
			}
		}
		if (itemKey.isSelfAppItemMode()) {
			if(StringUtils.isNotBlank(itemKey.getAppItem().getMultiImage())){
				return itemKey.getAppItem().getMultiImage();
			}else{
				return itemKey.getAppItem().getImage();
			}
		}
		if (itemKey.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKey.getAppItem().getMultiImage())) {
				return itemKey.getAppItem().getMultiImage();
			} else if (StringUtils.isNotBlank(itemKey.getAppItem().getImage())) {
				return itemKey.getAppItem().getImage();
			} else if (StringUtils.isNotBlank(itemKey.getItem().getMultiImage())) {
				return itemKey.getItem().getMultiImage();
			} else if (StringUtils.isNotBlank(itemKey.getItem().getImage())) {
				return itemKey.getItem().getImage();
			}
		}
		return null;
	}
	
	public String getMultiImage(){
		if (itemKey.isItemMode()) {
			return itemKey.getItem().getMultiImage();
		}
		if (itemKey.isSelfAppItemMode()) {
			return itemKey.getAppItem().getMultiImage();
		}
		if (itemKey.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKey.getAppItem().getMultiImage())) {
				return itemKey.getAppItem().getMultiImage();
			} else {
				return itemKey.getItem().getMultiImage();
			}
		}
		return null;
	}
	
	public String getBannerImage(){
		if (itemKey.isItemMode()) {
			return itemKey.getItem().getBannerImage();
		}
		if (itemKey.isSelfAppItemMode()) {
			return itemKey.getAppItem().getBannerImage();
		}
		if (itemKey.isDuibaAppItemMode()) {
			if (StringUtils.isNotBlank(itemKey.getAppItem().getBannerImage())) {
				return itemKey.getAppItem().getBannerImage();
			} else {
				return itemKey.getItem().getBannerImage();
			}
		}
		return null;
	}
	
	public String getDetailLink(){
		if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
			return "/mobile/detail?itemId=" + itemKey.getItem().getId() + "&dbnewopen";
		}
		if (itemKey.isSelfAppItemMode()) {
			if (itemKey.getAppItem().getSourceType() == AppItemDO.SourceTypeOperatingActivity) {
				return "/turntable/index/" + itemKey.getAppItem().getSourceRelationId() + "?dbnewopen";
			} else {
				return "/mobile/appItemDetail?appItemId=" + itemKey.getAppItem().getId() + "&dbnewopen";
			}
		}
		return null;
	}

	public Date getValidEndDate(){
		if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
			if (ItemDO.TypeCoupon.equals(itemKey.getItem().getType()) || ItemDO.TypeObject.equals(itemKey.getItem().getType())) {
				return itemKey.getItem().getValidEndDate();
			}
		}
		if (itemKey.isSelfAppItemMode()) {
			return itemKey.getAppItem().getValidEndDate();
		}
		return null;
	}
	
	public String getDescription(){
		if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
			return itemKey.getItem().getDescription();
		}
		if (itemKey.isSelfAppItemMode()) {
			return itemKey.getAppItem().getDescription();
		}
		return null;
	}
	
	public Double getPrice(){
		if (itemKey.isItemMode() || itemKey.isDuibaAppItemMode()) {
			if(itemKey.getItem().getMarketPrice()!=null){
				return itemKey.getItem().getMarketPrice() / 100.0;
			}
			return itemKey.getItem().getFacePrice() / 100.0;
		}
		if (itemKey.isSelfAppItemMode()) {
			return itemKey.getAppItem().getFacePrice() / 100.0;
		}
		return null;
	}
	
	public String getTitle(){
		if(itemKey.getAppItem()!=null){
			if(itemKey.getAppItem().getTitle()==null){
				if (itemKey.getItem() != null) {
					return itemKey.getItem().getName();
				}
				return null;
			}else{
				return itemKey.getAppItem().getTitle();
			}
		}else{
			return itemKey.getItem().getName();
		}
	}
	
	public Long getId(){
		if(itemKey.getAppItem()!=null){
			if(itemKey.getAppItem().getId()==null){
				if (itemKey.getItem() != null) {
					return itemKey.getItem().getId();
				}
				return null;
			}else{
				return itemKey.getAppItem().getId();
			}
		}else{
			return itemKey.getItem().getId();
		}
	}
	
	public String getType(){
		if(itemKey.getAppItem()!=null){
			if(itemKey.getAppItem().getType()==null){
				if (itemKey.getItem() != null) {
					return itemKey.getItem().getType();
				}
				return null;
			}else{
				return itemKey.getAppItem().getType();
			}
		}else{
			return itemKey.getItem().getType();
		}
	}
	
	public String getSubtitle(){
		if(itemKey.isItemMode()){
			return itemKey.getItem().getSubtitle();
		}else if(itemKey.isDuibaAppItemMode()){
			if(StringUtils.isBlank(itemKey.getAppItem().getSubtitle())){
				return itemKey.getItem().getSubtitle();
			}else{
				return itemKey.getAppItem().getSubtitle();
			}
		}else if(itemKey.isSelfAppItemMode()){
			return itemKey.getAppItem().getSubtitle();
		}else{
			return null;
		}
	}
	public ItemKey getItemKey() {
		return itemKey;
	}

	public Integer getUseStatus() {
		return useStatus;
	}

	public void setUseStatus(Integer useStatus) {
		this.useStatus = useStatus;
	}

	public Integer getMarkStatus() {
		return markStatus;
	}

	public void setMarkStatus(Integer markStatus) {
		this.markStatus = markStatus;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getEmbedType(){
		String embedType = null;
		if(getItemKey().getAppItem()!=null){
			AppItemDO ai=getItemKey().getAppItem();
			if(ai.getSourceType()==AppItemDO.SourceTypeOperatingActivity){
				if("duiba".equals(ai.getCustomPrice())) {
					embedType = EmbedDO.SourceTypeHdtoolTurntable;
				}
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaActivity){
				embedType = EmbedDO.SourceTypeDuibaActivity;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeSingleLottery){
				if("duiba".equals(ai.getCustomPrice())) {
					embedType = EmbedDO.SourceTypeSingleLottery;
				}
			}else if(ai.getSourceType()==AppItemDO.SourceTypeManualLottery){

			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaActivityItem){
				embedType=EmbedDO.SourceTypeNormal;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaActivitySingleLottery){
				embedType = EmbedDO.SourceTypeSingleLottery;
			}
			//Start chaijiangang,幸运转盘改为活动工具,2016/04/12
			/*else if(ai.getSourceType()==AppItemDO.SourceTypeAppShakeLottery){
				embedType = EmbedDO.SourceTypeNormal;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeAppShakeLottery){
				if("duiba".equals(ai.getCustomPrice())) {
					embedType = EmbedDO.SourceTypeHdtool;
				}
			}else if(ai.getSourceType()==AppItemDO.SourceTypeAppScratchCardLottery){
				if("duiba".equals(ai.getCustomPrice())) {
					embedType = EmbedDO.SourceTypeHdtool;
				}
			}else if(ai.getSourceType()==AppItemDO.SourceTypeHdtoolTiger){
				if("duiba".equals(ai.getCustomPrice())) {
					embedType = EmbedDO.SourceTypeHdtool;
				}
			}*/
			else if(ai.getSourceType()==AppItemDO.SourceTypeAppShakeLottery
					|| ai.getSourceType()==AppItemDO.SourceTypeAppScratchCardLottery
					|| ai.getSourceType()==AppItemDO.SourceTypeHdtoolTiger
					|| ai.getSourceType()==AppItemDO.SourceTypeHdtoolTurntable){
				if("duiba".equals(ai.getCustomPrice())) {
					embedType = EmbedDO.SourceTypeHdtool;
				}
			}
			//End chaijiangang,幸运转盘改为活动工具,2016/04/12
			else if(ai.getSourceType()==AppItemDO.SourceTypeGameSanta){
				embedType = EmbedDO.SourceTypeGame;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeGameGirl){
				embedType = EmbedDO.SourceTypeGame;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeGameYearAward){
				embedType = EmbedDO.SourceTypeGame;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaQuestionAnswer){
				embedType = EmbedDO.SourceTypeDuibaQuestionAnswer;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeSecondsKill){
				embedType = EmbedDO.SourceTypeSecondsKill;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeNgame){
				embedType=EmbedDO.SourceTypeNgame;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeGuess){
				embedType=EmbedDO.SourceTypeGuess;
			}
			//Start guoeryang,测试题、秒杀活动类型活动的数据埋点需求支持 ,2016/05/16
			else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaQuizz){
				embedType = EmbedDO.SourceTypeDuibaQuizz;
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaSeckill){
				embedType = EmbedDO.SourceTypeDuibaSeckill;
				//End guoeryang,测试题、秒杀活动类型活动的数据埋点需求支持 ,2016/05/16
			} else {
				if (ai.getItemId() != null) {
					embedType=EmbedDO.SourceTypeNormal;
				}
			}
		} else if(null != getItemKey().getItem()) {
			embedType=EmbedDO.SourceTypeNormal;
		}
		return embedType;
	}

	public String getLink(){
		String link=null;
		if(getItemKey().getAppItem()!=null){
			AppItemDO ai=getItemKey().getAppItem();
			if(ai.getSourceType()==AppItemDO.SourceTypeOperatingActivity){
				this.info_type =EmbedDO.InfoType_Turntable;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/turntable/index/"+ai.getSourceRelationId()+"?dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaActivity){
				this.info_type =EmbedDO.InfoType_Duiba_Activity;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/consumerDuibaActivity/list/"+ai.getSourceRelationId()+"?dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeSingleLottery){
				this.info_type =EmbedDO.InfoType_SingleLottery;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/singleLottery/index/"+ai.getSourceRelationId()+"?dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeManualLottery){
				this.info_type =EmbedDO.InfoType_AppManualLottery;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/ConsumerAppManualLottery/index/"+ai.getSourceRelationId()+"?dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaActivityItem){
				this.info_type =EmbedDO.InfoType_Duiba_Activity;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/mobile/detail?itemId="+ ai.getSourceRelationId() +"&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaActivitySingleLottery){
				this.info_type =EmbedDO.InfoType_Duiba_Activity;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/SingleLottery/index/" + ai.getSourceRelationId() + "?inlet=1&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeAppShakeLottery){
				this.info_type =EmbedDO.InfoType_Hdtool;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/shake/index/" + ai.getSourceRelationId() + "?dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeAppScratchCardLottery){
				this.info_type =EmbedDO.InfoType_Hdtool;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/ScratchCard/index/" + ai.getSourceRelationId() + "?dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeHdtoolTiger){
				link="/tiger/index/" + ai.getSourceRelationId() + "?dbnewopen";
			}
			//Start chaijiangang,幸运转盘改为活动工具,2016/04/12
			else if(ai.getSourceType()==AppItemDO.SourceTypeHdtoolTurntable){
				this.info_type =EmbedDO.InfoType_Hdtool;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/turntableNew/index/" + ai.getSourceRelationId() + "?dbnewopen";
			}
			//End chaijiangang,幸运转盘改为活动工具,2016/04/12
			else if(ai.getSourceType()==AppItemDO.SourceTypeGameSanta){
				this.info_type =EmbedDO.InfoType_Hdtool;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/santa/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeGameGirl){
				this.info_type =EmbedDO.InfoType_Game;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/girl/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeGameJiong){
				this.info_type =EmbedDO.InfoType_Game;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/jiong/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeGameYearAward){
				this.info_type =EmbedDO.InfoType_Game;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/yearAward/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaQuestionAnswer){
				this.info_type =EmbedDO.InfoType_Game;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/question/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaQuizz){
				this.info_type =EmbedDO.InfoType_Quizz;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/quizz/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeSecondsKill){
				this.info_type =EmbedDO.InfoType_SecondsKill;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/SecondsKillActivity/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeDuibaSeckill){
				this.info_type =EmbedDO.InfoType_Seckill;
				this.info =String.valueOf(ai.getSourceRelationId());
				link= SeckillDomainConstant.appDuibaSeckillDomainName + "/seckill/index/" + ai.getSourceRelationId() + "?dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeNgame){
				this.info_type =EmbedDO.InfoType_NGame;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/ngame/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else if(ai.getSourceType()==AppItemDO.SourceTypeGuess){
				this.info_type =EmbedDO.InfoType_Guess;
				this.info =String.valueOf(ai.getSourceRelationId());
				link="/guess/index?id=" + ai.getSourceRelationId() + "&dbnewopen";
			}else{
				if (ai.getItemId() != null) {
					this.info_type =EmbedDO.InfoType_Items;
					this.info =String.valueOf(ai.getItemId());
					link="/mobile/detail?itemId="+ai.getItemId()+"&dbnewopen";
				} else {
					this.info_type =EmbedDO.InfoType_AppItem;
					this.info =String.valueOf(ai.getId());
					link="/mobile/appItemDetail?appItemId="+ai.getId()+"&dbnewopen";
				}
			}
		}else{
			this.info_type =EmbedDO.InfoType_AppManualLottery;
			this.info =String.valueOf(getItemId());
			link="/mobile/detail?itemId="+getItemId()+"&dbnewopen";
		}
		return link;
	}
}
