package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.activity.center.api.dto.duibaactivity.DuibaActivityDto;
import cn.com.duiba.activity.center.api.dto.singlelottery.DuibaSingleLotteryDto;

/**
 * 兑吧单品抽奖业务DAO
 */
public interface RemoteDuibaSingleLotteryService {


	//from AdminDuibaSingleLotteryManager from manager

	/**
	 * 更新单品抽奖的主奖项库存
	 */
	public void updateMainItemRemainingByEdit(Long duibaSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException;

	/**
	 * 更新单品抽奖的鼓励奖的库存
	 */
	public void updateInciteItemRemainingByEdit(Long duibaSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException;

	/**
	 * 添加专题活动的子活动到开发者活动中
	 */
	public void addChildrenActivityToDeveloper(DuibaActivityDto duibaActivity, Long operatingActivityId, Long appId);

	/**
	 * 关闭并且未发布/后台关闭并且下架单品抽奖
	 */
	public DuibaSingleLotteryDto closeAndUnViewSingleLottery(Long id);

	/**
	 * 把兑吧单品抽奖添加到开发者
	 */
	public Long addSingleLotteryToDeveloper(Long appId, Long duibaSingleLotteryId, String isPreview) throws BusinessException;

	/**
	 * 关闭
	 */
	public DuibaSingleLotteryDto closeDuibaSingleLotteryNoTransaction(Long id);

	/**
	 * 删除
	 * @return
	 */
	public DuibaSingleLotteryDto deleteSingleLottery(Long id);

	/**
	 * 更新单品抽奖
	 */
	public void updateSingleLottery(DuibaSingleLotteryDto duibaSingleLottery);

	/**
	 * 开启
	 */
	public void startupSingleLottery(Long id);

	/**
	 * 来自AdminDuibaSingleLotteryCtrl.update
	 * 更新单品抽奖
	 */
	public void updateSingleLotteryAndItemRemainingByEdit(DuibaSingleLotteryDto duibaSingleLottery, Integer preMainItemRemaining, Integer mainItemRemaining, Integer preInciteItemRemaining, Integer inciteItemRemaining) throws BusinessException;

}
