package cn.com.duiba.service.domain.dataobject;


import cn.com.duiba.service.domain.BaseDO;

import java.util.Date;

/**
 * 兑吧精选内容
 */
public class DuibaCullingDO extends BaseDO {
	private static final long serialVersionUID = -2306338604842903154L;

	public static final String SOURCE_TYPE_ITEM = "item"; // 来源item
	public static final String SOURCE_TYPE_DUIBA_TURNTABLE = "duibaTurntable"; // 来源duibaTurntable
	public static final String SOURCE_TYPE_DUIBA_SINGLE_LOTTERY = "duibaSingleLottery"; // 来源duibaSingleLottery
	public static final String SOURCE_TYPE_DUIBA_ACTIVITY = "duibaActivity"; // 来源duibaActivity
	public static final String SOURCE_TYPE_DUIBA_HDTOOL= "duibaHdtool";//来源于duibaHdTool
	public static final String SOURCE_TYPE_DUIBA_GAME= "duibaGame";//来源于duibaGame
	public static final String SOURCE_TYPE_DUIBA_SECONDS_KILL= "duibaSecondsKillActivity";//来源于duibaSecondsKillActivity
	public static final String SOURCE_TYPE_DUIBA_QUESTION = "duibaQuestion";	// 来源于duibaQuestion
	public static final String SOURCE_TYPE_DUIBA_QUIZZ = "duibaQuizz";	// 来源于duibaQuizz
	public static final String SOURCE_TYPE_DUIBA_SECKILL = "duibaSeckill";	// 来源于duibaSeckill
	public static final String SOURCE_TYPE_DUIBA_NGAME= "duibaNgame";//来源于duibaNgame
	public static final String SOURCE_TYPE_DUIBA_GUESS= "duibaGuess";//来源于duibaGuess
	public static final String SOURCE_TYPE_DUIBA_CREDIT_GAME= "creditGame";//来源于creditGame
	
	public static final String TYPE_PHONEBILL = "phonebill"; // 话费
	public static final String TYPE_PHONEFLOW = "phoneflow"; // 流量
	public static final String TYPE_ALIPAY = "alipay"; // 支付宝
	public static final String TYPE_QB = "qb"; // Q币
	public static final String TYPE_COUPON = "coupon"; // 优惠券
	public static final String TYPE_OBJECT = "object"; // 实物
	public static final String TYPE_DUIBA_TURNTABLE = "duibaTurntable"; // 兑吧大转盘
	public static final String TYPE_DUIBA_SINGLE_LOTTERY = "duibaSingleLottery"; // 兑吧单品抽奖
	public static final String TYPE_DUIBA_ACTIVITY = "duibaActivity"; // 专题活动
	public static final String TYPE_DUIBA_SHAKE = "duibaShake";//摇一摇
	public static final String TYPE_DUIBA_SCRATCH = "duibaScratch";//刮刮乐
	public static final String TYPE_DUIBA_TIGER = "duibaTiger";//老虎机
	public static final String TYPE_DUIBA_FLOP = "duibaFlop";//趣味翻牌
	public static final String TYPE_DUIBA_SMASHG = "duibaSmashg";//砸彩蛋
	//Start chaijiangang,幸运转盘改为活动工具,2016/04/26
	public static final String TYPE_DUIBA_HDTOOL_TURNTABLE = "duibaHdToolTurntable";//活动工具幸运转盘
	//End chaijiangang,幸运转盘改为活动工具,2016/04/26
	public static final String TYPE_SANTA = "santa";//打圣诞老人
	public static final String TYPE_YEAR_AWARD = "yearAward";//数年终奖
	public static final String TYPE_GIRL = "girl";//女神pk
	public static final String TYPE_JIONG = "jiong";//人在囧途

	public static final String GAME_TYPE_SANTA = "gameSanta";//打圣诞老人
	public static final String GAME_TYPE_YEAR_AWARD = "gameYearAward";//数年终奖
	public static final String GAME_TYPE_GIRL = "gameGirl";//女神pk
	public static final String GAME_TYPE_JIONG = "gameJiong";//人在囧途
	public static final String TYPE_DUIBA_SECONDS_KILL_ACTIVITY = "duibaSecondsKillActivity";//秒杀专题
	public static final String TYPE_DUIBA_QUESTION = "duibaQuestion";	// 兑吧答题活动
	public static final String TYPE_DUIBA_QUIZZ = "duibaQuizz";	// 兑吧测试题活动
	public static final String TYPE_DUIBA_SECKILL = "duibaSeckill";	// 兑吧秒杀活动
	public static final String TYPE_DUIBA_NGAME = "duibaNgame";	// 兑吧新游戏
	public static final String TYPE_DUIBA_GUESS = "duibaGuess";    // 兑吧竞猜
	public static final String TYPE_DUIBA_CREDIT_GAME = "creditGame"; //积分游戏

	private Long id;

	private Integer payload;

	private String sourceType;

	private Long sourceId;

	private String sourceTitle;

	private String type;

	private String sourceName4admin;

	private Date gmtCreate;

	private Date gmtModified;

	public DuibaCullingDO() {
	}

	public DuibaCullingDO(Long id) {
		this.id = id;
		this.gmtModified = new Date();
		toBeUpdate = true;
	}

	public DuibaCullingDO(boolean init4insert) {
		if (init4insert) {
			toBeInsert = true;
			payload = 0;
			gmtCreate = new Date();
			gmtModified = gmtCreate;
		}
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getPayload() {
		return payload;
	}

	public void setPayload(Integer payload) {
		this.payload = payload;
	}

	public String getSourceType() {
		return sourceType;
	}

	public void setSourceType(String sourceType) {
		this.sourceType = sourceType;
	}

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	public String getSourceTitle() {
		return sourceTitle;
	}

	public void setSourceTitle(String sourceTitle) {
		this.sourceTitle = sourceTitle;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getSourceName4admin() {
		return sourceName4admin;
	}

	public void setSourceName4admin(String sourceName4admin) {
		this.sourceName4admin = sourceName4admin;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}
	
	/**
	 * 兑吧活动名称转换值 
	 * @author zhengjy
	 * @return
	 */
	public  Integer duibaActivityNameToValue(){
		if(TYPE_DUIBA_HDTOOL_TURNTABLE.equals(this.type)){
			return DeveloperBlackDO.TypeHdToolTurntable;
		}else if(TYPE_DUIBA_SHAKE.equals(this.type)){
			return DeveloperBlackDO.TypeShakeLottery;
		}else if(TYPE_DUIBA_SCRATCH.equals(this.type)){
			return DeveloperBlackDO.TypeScratchCard;
		}else if(TYPE_DUIBA_TIGER.equals(this.type)){
			return DeveloperBlackDO.TypeHdToolTiger;
		}else if(TYPE_DUIBA_FLOP.equals(this.type)){
            return DeveloperBlackDO.TypeHdToolFlop;
        }else if(TYPE_DUIBA_SMASHG.equals(this.type)){
            return DeveloperBlackDO.TypeHdToolSmashg;
        }else if(TYPE_DUIBA_ACTIVITY.equals(this.type)){
			return DeveloperBlackDO.TypeDuibaActivity;
		}else if(TYPE_DUIBA_SINGLE_LOTTERY.equals(this.type)){
			return DeveloperBlackDO.TypeDuibaSingleLottery;
		}else if(TYPE_SANTA.equals(this.type) || GAME_TYPE_SANTA.equals(this.type)){
			return DeveloperBlackDO.TypeGameSanta;
		}else if(TYPE_YEAR_AWARD.equals(this.type) ||GAME_TYPE_YEAR_AWARD.equals(this.type)){
			return DeveloperBlackDO.TypeGameYearAward;
		}else if(TYPE_GIRL.equals(this.type)|| GAME_TYPE_GIRL.equals(this.type)){
			return DeveloperBlackDO.TypeGameGirl;
		}else if(TYPE_JIONG.equals(this.type) ||GAME_TYPE_JIONG.equals(this.type)){
			return DeveloperBlackDO.TypeGameJiong;
		}else if(TYPE_DUIBA_SECONDS_KILL_ACTIVITY.equals(this.type)){
			return DeveloperBlackDO.TypeSecondsKill;
		}else if(TYPE_DUIBA_QUESTION.equals(this.type)){
			return DeveloperBlackDO.TypeDuibaQuestionAnswer;
		}else if(TYPE_DUIBA_QUIZZ.equals(this.type)){
			return DeveloperBlackDO.TypeDuibaQuizz;
		}else if(TYPE_DUIBA_SECKILL.equals(this.type)){
			return DeveloperBlackDO.TypeDuibaSeckill;
		}else if(TYPE_COUPON.equals(this.type) || TYPE_OBJECT.equals(this.type)){
			return DeveloperBlackDO.TypeItem;
		}
		return null;
		
	}

	@Override
	public String toString() {
		return "DuibaCullingDO [id=" + id + "]";
	}
}
