package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AddrLimitDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.item.domain.vo.ItemKeyVO;

import java.util.List;

public interface RemoteAddrLimitService {

	public List<AddrLimitDO> findAddrLimitByAppItemId(Long appItemId);

	public List<AddrLimitDO> findAddrLimitByItemId(Long itemId);

	public Integer findTypeByAppItemId(Long appItemId);

	public Integer findTypeByItemId(Long itemId);

	public void batchInsertAddrLimit(List<AddrLimitDO> addrLimitList);

	public void deleteAddrLimit(Long itemId, Long appItemId);

	/**
	 * 首页button区过滤
	 * 包括优惠券，自定义分类，所有兑换项
	 */
	public List<ItemKey> mobileButtonAddrLimitFilter(List<ItemKey> iks, String ip);

	/**
	 * 首页优惠券过滤
	 */
	public List<ItemKeyVO> mobileIndexAddrLimitFilter(List<ItemKeyVO> ikvs, String ip);
}
