package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.TurntableStockConsumeDO;
import cn.com.duiba.service.exception.BusinessException;

/**
 * 来自TurntableConsumeStockServiceImpl
 */
public interface RemoteTurntableStockConsumeService {

	public TurntableStockConsumeDO insert(TurntableStockConsumeDO turntableStockConsumeDO);
	
	public TurntableStockConsumeDO findByBizIdAndSourcePay(String bizId, String bizSource);

	/**
	 * 兑吧大转盘扣奖项库存
	 * @param optionId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 */
	public void consumeDuibaTurntableOptionStock(Long optionId,Long appId,String bizId,String bizSource) throws BusinessException;

	/**
	 * 兑吧大转盘返奖项库存
	 * @param bizId
	 * @param bizSource
	 */
	public void paybackDuibaTurntableOptionStock(String bizId,String bizSource) throws BusinessException;

	/**
	 * 开发者大转盘扣奖项库存
	 * @param optionId
	 * @param appId
	 * @param bizId
	 * @param bizSource
	 */
	public void consumeAppTurntableOptionStock(Long optionId,Long appId,String bizId,String bizSource) throws BusinessException;

	/**
	 * 开发者大转盘返奖项库存
	 * @param bizId
	 * @param bizSource
	 */
	public void paybackAppTurntableOptionStock(String bizId,String bizSource) throws BusinessException;
}
