package cn.com.duiba.service.tools;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import org.apache.commons.lang.StringUtils;

public class ItemCornerTagUtils {
	
	private static String CustomTagSplitSymbol = ",";
	private static Joiner joiner = Joiner.on(CustomTagSplitSymbol).skipNulls();
	//将CustomTag分割后，每部分的意义
	public static int CustomTag_No1 = 0;//自定义角标文案
	public static int CustomTag_No2 = 1;//自定义角标颜色
	
	/**
	 * 得到自有兑换项自定义角标的文案
	 * 不会返回null
	 * @param appItem
	 * @return
	 */
	public static String getCustomTagText(Optional<AppItemDO> appItem){
		String custom = appItem.get().getCustomTag();
		if(StringUtils.isBlank(custom)){
			return "";
		}
		String[] ss = custom.split(CustomTagSplitSymbol);
		if(ss.length ==0){
			return "";
		}
		return ss[CustomTag_No1];
	}
	/**
	 * 得到自有兑换项自定义角标的底色
	 * 不会返回null
	 * @param appItem
	 * @return
	 */
	public static String getCustomTagColor(Optional<AppItemDO> appItem){
		String custom = appItem.get().getCustomTag();
		if(StringUtils.isBlank(custom)){
			return "#fe4a21";
		}
		String[] ss = custom.split(CustomTagSplitSymbol);
		if(ss.length < CustomTag_No2+1){
			return "#fe4a21";
		}
		return ss[CustomTag_No2];
	}
	
	public static String getCustomTag(String customTagText,String customTagColor) throws Exception{
		if(StringUtils.isBlank(customTagText) || StringUtils.isBlank(customTagColor)){
			throw new Exception("自定义角标信息不完整");
		}
		return joiner.join(customTagText, customTagColor);
	}
}
