package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.CouponCountVO;
import cn.com.duiba.service.domain.vo.ItemKey;

import java.util.List;
import java.util.Map;

/**
 * Created by wenqi.huang on 16/5/4.
 */
public interface RemoteCouponService {

    public void insert(CouponDO couponDO);

    public int update(CouponDO couponDO);

    public CouponDO find(Long id);

    /**
     * 根据批次查询一个未锁定，未使用的优惠券
     * @param batchId
     * @return
     */
    public CouponDO findOneCouponByBatchId(Long batchId);

    /**
     * 锁定一张（未锁定，未使用的优惠券）
     * @param couponId
     * @return
     */
    public int lockCoupon(long couponId);

    /**
     * 解锁一张（已锁定，未使用的优惠券）
     * @param couponId
     * @return
     */
    public int unlockCoupon(long couponId);

    /**
     * 通过批次ID删除批次下
     * @param couponId
     * @return
     */
    public int deleteByBatchId(long batchId);

    /**
     * 查询批次下所有券码
     */
    public List<String> findAllCodeByBatchId(long batchId);

    /**
     * 释放优惠券
     * @param orderId
     */
    public void releaseCouponById(Long couponId);

    /**
     * 批量插入优惠券
     * @param ls
     */
    public void batchInsertCoupon(List<CouponDO> ls);
    /**
     * 根据ID批量删除优惠券
     * @param ls
     */
    public Integer batchDeleteCoupon(List<Long> ls);


    /**
     * 删除一张未使用的优惠券
     * @param id
     * @return
     */
    public Integer deleteOneCoupon(Long id);


    /**
     * 删除一个批次里所有未使用优惠券,每次删除1000条，所以此方法需要循环调用
     * @param batchId
     * @return
     */
    public Integer deleteCouponByBatch(Long batchId);

    /**
     * 是否存在优惠券
     * @param batchId
     * @return
     */
    public Integer ishavingCoupon(Long batchId);


    /**
     * 找一张优惠券
     * @param batchId
     * @return
     */
    public CouponDO findOneByBatch(Long batchId);
    public CouponDO findByBatchAndCode(Long batchId, String code);

    /**
     * 根据批次号获取一批优惠券
     * @param batchId
     * @param max
     * @return
     */
    public List<CouponDO> findNoUsedByBatch(Long batchId, Integer max);


    /**
     * 优惠券搜索
     * @param code
     * @param batchId
     * @param start
     * @param pageSize
     * @return
     */
    public List<CouponDO> searchCoupon(Long appItemId, Long itemId, String code, Long batchId, String used, Integer start, Integer pageSize);

    public Integer countCoupon(Long appItemId, Long itemId, Long batchId);

    public Integer countUsedCoupon(Long appItemId, Long itemId, Long batchId);

    /**
     * 根据itemId计算coupon数量
     */
    public Integer countByItemId(Long itemId);

    /**
     * @AUTH: ZhangPan
     * @Date: 2015年1月5日 下午7:40:24
     * @Description:根据Id列表查询优惠券列表
     */
    public List<CouponDO> findCouponList(List<Long> list);

    /**
     * 统计某批次优惠券剩余数量
     * @param batchId
     * @return
     */
    public Integer countByCouponBatch(Long batchId);
    /**
     * 没有锁定也没有使用的量
     * @param batchId
     * @return
     */
    public Integer noLockCountByBatchId(Long batchId);

    /**
     * 优惠券翻页
     */
    public List<CouponDO> findCouponByLimit(Map<String, Object> params);
    public Long findCouponByCount(Map<String, Object> params);

    /**
     * 根据itemIds获取每个item的优惠券数量
     */
    public List<CouponCountVO> countByItemIds(List<Long> itemIds);

    /**按批次ID，和导出总数查询**/
    public List<CouponDO> findCouponByBatchAndTotal(Map<String, Object> map);

    /**
     * 获取兑换项的当前批次
     *
     * @param itemKey
     * @return
     */
    public CouponBatchDO getCurrentBatch(ItemKey itemKey);

    /**
     * 使用一张优惠券
     *
     * @param couponId
     */
    public void useCoupon4Order(Long couponId);

    public void bindOrderToCoupon(Long orderId, Long couponId);
}
