package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppBannerDO;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

/**
 * Created by wenqi.huang on 16/4/27.
 */
public interface RemoteAppBannerService {

    public List<AppBannerDO> findAllByIds(List<Long> ids);

    public List<Long> findAppIdsByIds(List<Long> ids);

    public AppBannerDO find(Long id);

    public AppBannerDO insert(AppBannerDO appBanner);

    public Integer update(AppBannerDO appBanner);

    public List<AppBannerDO> findIconClassify(Long appId, Long classifyId);


    /**
     * 删除自定义banner
     * @param delete
     * @param relationId
     * @param appId
     * @return
     */
    public Integer deleteByClassify(Boolean delete,Long relationId,Long appId);

    /**
     * 根据appBannerIds禁用appBanner
     * @param appBannerIdList
     * @return
     */
    public Integer disableAppBannerByIds(List<Long> appBannerIdList);


    public Integer disableByActivityId(Boolean delete,Long activityId,Integer type);


    public Integer disableByOperatingActivityId(Boolean delete,Long relationId);


    public Integer disableByAppItemId(Long appItemId);

    public Integer disableByItemId(Long itemId);

    public Integer disableByAppIdAndAppItemId(Long appId,Long appItemId);

    public Integer updateNameImage(Long id, String name, String image);



    public AppBannerDO findExistBanner(Long appId, Long appItemId,String type);


    public Integer findBannerNumByType(Long appId,String type);


    public Integer findMaxPlayload(Long appId,String type);


    public List<AppBannerDO> findAllByAppIdDeleteAndType(Long appId,String type,Boolean deleted);


    public List<AppBannerDO> findAllByAppId(Long appId,Boolean deleted);


    public List<AppBannerDO> findAllByItemId(Long itemId);

    public List<AppBannerDO> findByAppItemId(Long appItemId);

    /**
     * 查询APP首页banner, Icon
     */
    public List<AppBannerDO> findHomeBannerByCache(AppDO app, boolean deleted);

    /**
     * 添加链接banner
     *
     * @param name
     *            名称
     * @param iamge
     *            图片地址
     * @param url
     *            链接跳转地址
     * @return 主键ID
     */
    public Long addLinkBanner(Long appId, String name, String image, String url);

    /**
     * 保存或修改appButton
     *
     * @param appBanner
     * @return
     * @throws BusinessException
     */
    public AppBannerDO saveOrUpdateAppButton(AppBannerDO appBanner) throws BusinessException;

    /**
     * 删除banner
     *
     * @param id
     *            主键ID
     * @return true删除成功 false删除失败
     */
    public Boolean deleteBanner(Long id);

    /**
     * 保存/修改 大转盘AppBanner
     */
    public void saveAppBannerByTurntable(AppBannerDO appBanner, long turntableId) throws BusinessException;

    /**
     * 保存或修改appBanner
     *
     * @param appBanner
     * @return
     * @throws Exception
     */
    public AppBannerDO saveOrUpdateAppBanner(AppBannerDO appBanner) throws BusinessException;


    public void updateAppBannerByTurntable(AppBannerDO appBanner, long turntableId) throws BusinessException;
}
