package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

/**
 * Created by wenqi.huang on 16/4/20.
 */
public interface RemoteDevCustomMService {
    /**
     * 保存推荐设置
     * @param developerId
     * @param appId
     * @param autoRecommend 是否开启自动推荐
     * @param tagids 自动推荐项的ID集合
     * @throws Exception
     */
    public void doSet(Long developerId, Long appId,boolean autoRecommend,List<Long> tagids) throws BusinessException;

    /**
     * 对传入的appItem序列进行权重倒序排序，
     * @param developerId
     * @param appId
     * @param sortAppItemIds 需要排序的AppItemId列表
     * @throws Exception
     * @author 刘瑶
     */
    public void indexItemSort(Long developerId,Long appId,List<Long> sortAppItemIds) throws BusinessException;
    /**
     * appItem序列置顶
     * @param developerId
     * @param appId
     * @param appItemId 需要置顶的AppItemId
     * @throws Exception
     * @author 刘瑶
     */
    public void setTop4IndexItem(Long developerId,Long appId, Long appItemId) throws BusinessException;
    /**
     * appItem取消置顶
     * @param developerId
     * @param appId
     * @param appItemId 需要取消置顶的AppItemId
     * @throws Exception
     * @author 刘瑶
     */
    public void cancelTop4IndexItem(Long developerId,Long appId, Long appItemId) throws BusinessException;
}
