package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.DuibaShowcaseTaskContentDO;
import cn.com.duiba.service.domain.dataobject.DuibaShowcaseTaskDO;
import cn.com.duiba.service.domain.queryparams.AShowcaseTaskQueryEntity;
import cn.com.duiba.service.exception.BusinessException;

import java.util.List;

public interface RemoteDuibaShowcaseTaskService {

	List<DuibaShowcaseTaskDO> find(AShowcaseTaskQueryEntity entity);
	
	int count(AShowcaseTaskQueryEntity entity);

	DuibaShowcaseTaskDO add(DuibaShowcaseTaskDO taskDO);
	
	DuibaShowcaseTaskDO get(Long id);
	
	void update(DuibaShowcaseTaskDO taskDO);
	
	void delete(Long id);

	//DuibaShowcaseTaskSimpleDAO

	/**
	 * 推送成功，更新状态
	 */
	public void makePushSuccess(Long id, Integer successCount);

	/**
	 * 取消成功，更新状态
	 */
	public void makeCancelSuccess(Long id);

	//from DuibaShowcaseTaskManagerImpl

	/**
	 * 推送兑吧的橱窗任务给apps
	 * @throws Exception
	 */
	public void pushDuibaShowcaseToApps(Long id) throws BusinessException;

	/**
	 * 取消兑吧推送给APP的任务
	 */
	public void cancelDuibaShowcase(Long id) throws BusinessException;

	//from DuibaShowcaseService
	public DuibaShowcaseTaskDO addShowcaseTask(DuibaShowcaseTaskDO taskDO, List<DuibaShowcaseTaskContentDO> list);
}
