package cn.com.duiba.service.domain.dataobject;

import java.util.Date;

import org.apache.commons.lang.StringUtils;

import cn.com.duiba.service.domain.BaseDO;

public class AppBulletinDO extends BaseDO {
	/**
     * serialVersionUID:TODO(用一句话描述这个变量表示什么).
     * @since JDK 1.6
     */
    private static final long serialVersionUID = 6104991714012894516L;
    public static final int PagePath_None = 0;
	public static final int PagePath_MySelf = 1;
	public static final int PagePath_Duiba = 2;
	
	private Long id;
	private Long appId;
	private String noticeText;
	private String bgColor;
	private Integer pagePath;
	private String noticeLink;
	private String detailText;
	
	private Date gmtCreate;
	private Date gmtModified;
	
	private transient Boolean open;
	
	public void verif() throws Exception{
		if(!open){
			return;
		}
		if(StringUtils.isBlank(noticeText)){
			throw new Exception("公告内容不能为空");
		}
		if(StringUtils.isBlank(bgColor)){
			throw new Exception("公告背景色不能为空");
		}
		if(pagePath == null){
			throw new Exception("公告详情指向不能为空");
		}
		if(pagePath!=PagePath_None){
			switch (pagePath) {
				case PagePath_MySelf:
					if(StringUtils.isBlank(noticeLink)){
						throw new Exception("公告详情链接不能为空");
					}
					if(!StringUtils.contains(noticeLink, "://")){
						throw new Exception("公告链接不符合规范");
					}
					break;
				case PagePath_Duiba:
					if(StringUtils.isBlank(detailText)){
						throw new Exception("公告详情内容不能为空");
					}
					if(detailText.length()>2000){
					    throw new Exception("不能超过2000个字符");
					}
					break;
				default:throw new Exception("公告详情指向参数异常");
			}
		}
	}
	
	public AppBulletinDO(){}
	
	public void init(){
		bgColor = "#fff9d4";
		pagePath = 0;
		noticeText= "";
		noticeLink = "";
		detailText = "";
		open = false;
	}
	
	public AppBulletinDO(boolean init4insert){
		if (init4insert) {
			toBeInsert = true;
		
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getAppId() {
		return appId;
	}
	public void setAppId(Long appId) {
		this.appId = appId;
	}
	public String getNoticeText() {
		return noticeText;
	}
	public void setNoticeText(String noticeText) {
		this.noticeText = noticeText;
	}
	public String getBgColor() {
		return bgColor;
	}
	public void setBgColor(String bgColor) {
		this.bgColor = bgColor;
	}
	public Integer getPagePath() {
		return pagePath;
	}
	public void setPagePath(Integer pagePath) {
		this.pagePath = pagePath;
	}
	public String getNoticeLink() {
		return noticeLink;
	}
	public void setNoticeLink(String noticeLink) {
		this.noticeLink = noticeLink;
	}
	public String getDetailText() {
		return detailText;
	}
	public void setDetailText(String detailText) {
		this.detailText = detailText;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Boolean getOpen() {
		return open;
	}

	public void setOpen(Boolean open) {
		this.open = open;
	}
}
