package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.item.domain.dataobject.AppItemClassifyDO;
import cn.com.duiba.service.item.domain.dataobject.AppItemClassifyRelationDO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

public interface RemoteAppItemClassifyService {

	public Long findByCount(Map<String, Object> params);

	public List<AppItemClassifyDO> findByLimit(Map<String, Object> params);

	public List<AppItemClassifyDO> findAllByAppId(Long appId);
	
	public int batchInsert(List<Map<String, Object>> classifyRelation);
	
	public List<Long> findAllAppItemById(Long classifyId);
	
	public int deleteAppItemRelation(List<Long> ids, Long appId);
	
	public void insert(AppItemClassifyDO appItemClassifyDO);
	
	public AppItemClassifyDO find(Long id);
	
	public void update(AppItemClassifyDO appItemClassifyDO);
	
	public int deleteClassifyAppItem(Long classifyId, Long appItemId);
	
	public List<AppItemDO> findClassifyAppItems(Long classifyId, Long appId, String status, Integer start, Integer pageSize);
	
	public List<AppItemDO> findAppItemNoExistClassify(Map<String, Object> query, Integer start, Integer pageSize);
	public Integer findAppItemNoExistClassifyCount(Map<String, Object> query, Integer start, Integer pageSize);
	
	public Integer deleteClassifyAllAppItem(Long classifyId);
	
	public Integer deleteRelationAppItem(Long appItemId);
	
	public Integer findMaxPayload(Long classifyId);
	
	public Integer updatePayload(Long appItemId, Long classifyId, Integer payload);

	public List<AppItemClassifyDO> findByIds(List<Long> ids);
	
	public List<AppItemClassifyRelationDO> findRelationByAppItemIds(List<Long> appItemIds);
	
	/**
     * 查询首页展示的自定义分类商品
     */
    DubboResult<List<AppItemDO>> findHomeClassifyAppItems(Long appId, Long classifyId);
    
    /**
     * 自定义分类商品排序
     */
    DubboResult<Void> sortByClassifyPayload(Long classifyId, Long appItemId, Integer startPayload, Integer endPayload);
    
    /**
     * 自定义分类商品置顶
     */
    DubboResult<Void> setTop(Long classifyId, Long appItemId);
    
    /**
     * 自定义分类商品取消置顶
     */
    DubboResult<Void> cancleTop(Long classifyId, Long appItemId);
}
