package cn.com.duiba.service.item.remoteservice;

import cn.com.duiba.service.item.domain.dataobject.ItemAppSpecifyDO;
import cn.com.duiba.service.item.domain.vo.ItemAppSpecifyVO;

import java.util.Date;
import java.util.List;

/**
 * Created by wenqi.huang on 16/5/9.
 */
public interface RemoteItemAppSpecifyService {
    /**
     * 查找兑换项的定向关系表
     * @param itemId
     * @return
     */
    public List<ItemAppSpecifyVO> findAllByItemId(Long itemId);

    /**
     * 删除定向关系
     * @param id
     */
    public void delete(Long id);

    /**
     * 根据兑换项ID和appId查找定向库存，没有则为NULL
     * @param itemId
     * @param appId
     * @return
     */
    public Integer findSpecifyRemaining(Long itemId, Long appId);

    /**
     * 根据itemId和appId
     */
    public ItemAppSpecifyDO findByItemIdAndAppId(Long itemId, Long appId);

    public void insert(ItemAppSpecifyDO itemAppSpecifyDO);

    public ItemAppSpecifyDO find(Long id);

    public void updateRemaining(Long id, Integer remaining);

    /**
     * 根据兑换项ID和appId查找
     */
    public List<ItemAppSpecifyDO> findSpecifyByItemIdsAndAppId(List<Long> itemIds,Long appId);


    /**
     * 找出不是该APP的定向商品
     * @param appId
     * @return
     */
    public List<Long> findNOSpecify4App( Long appId);

    /**
     * 找出不是该APP的（后台新加的开发者未浏览过的）定向商品
     * @param appId
     * @return
     */
    public List<Long> findNOSpecify4AppNew( Long appId, Date newItemTime);


    public int reduceRemaining(Long itemId,Long appId);
    public int increaseRemaining( Long itemId,Long appId);

    public ItemAppSpecifyDO findByItemIdAndAppIdLock(Long itemId,Long appId);

}
