package cn.com.duiba.service.remoteservice;

import cn.com.duiba.service.domain.dataobject.CouponCodeBatchDO;
import cn.com.duiba.wolf.dubbo.dispatcher.RunInExecutor;

import java.util.Date;
import java.util.List;
import java.util.Map;

@RunInExecutor("dubboOtherThreadPool")
public interface RemoteCouponCodeBatchService {
    public List<CouponCodeBatchDO> findAllByBaseId(Long baseId);

    public CouponCodeBatchDO findBatchByBatchNameAndEffectTime(Long baseId, String name, Date beginEffectTime, Date endEffectTime);

    public int deleteBatchById(Long batchId);

    public CouponCodeBatchDO insertBatch(CouponCodeBatchDO batch);

    public int findBatchCountByBaseId(Long baseId);

    public CouponCodeBatchDO findCouponCodeBatchByBatchId(Long batchID);

    public List<CouponCodeBatchDO> findListByBatchIdAndDate(Map<String, Object> maps);

}
