package cn.com.duiba.service.remoteservice;

import java.util.Date;
import java.util.List;

import cn.com.duiba.service.domain.dataobject.OdpsAppDailyStatDO;

public interface RemoteOdpsAppDailyStatService {
	/**
	 * 查询月数据
	 * @param appId
	 * @param month
	 * @return
	 */
	public List<OdpsAppDailyStatDO> findAppDailyStatByMonth(Long appId,String month);
	
	/**
	 * 查询月数据
	 * @param appId
	 * @param month
	 * @return
	 */
	public OdpsAppDailyStatDO findSumAppDailyStatByMonth(Long appId,String month);


	/**
	 *
	 * @param appId
	 * @param start  yyyyMMdd
	 * @return
	 */
	public OdpsAppDailyStatDO findStatByAppAtDay(Long appId, String day);


	/**
	 * 根据App和时间区间查询
	 */
	public List<OdpsAppDailyStatDO> findStatByAppIdAndDayBetween(Long appId, Date start, Date end);

	/**
	 * 查询时间区间内的数据，将所有数据累计，返回单条记录
	 * 主要用于展示：本周数据，本月数据
	 * @param appId
	 * @param start
	 * @param end
	 * @return
	 */
	public OdpsAppDailyStatDO findByAppMerge(Long appId, String start, String end);

}
