/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.service.impl;

import cn.com.duiba.service.dao.credits.developer.DeveloperDao;
import cn.com.duiba.service.dao.credits.developer.RemainingMoneyDao;
import cn.com.duiba.service.domain.dataobject.DeveloperDO;
import cn.com.duiba.service.domain.dataobject.RemainingMoneyDO;
import cn.com.duiba.service.domain.queryparams.ADeveloperQueryEntity;
import cn.com.duiba.service.service.DeveloperService;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeveloperServiceImpl
implements DeveloperService {
    @Resource
    private DeveloperDao developerDao;
    @Resource
    private RemainingMoneyDao remainingMoneyDao;
    @Resource
    private CacheClient cacheClient;
    @Value(value="#{configProperties['app.balance.key']}")
    private String privateKey;

    private String getCacheKeyById(Long id) {
        return "chaos.keyDeveloperId_" + id;
    }

    @Override
    @Transactional(value="credits")
    public void insertDeveloper(DeveloperDO developer) {
        this.developerDao.insert(developer);
        developer = this.developerDao.findByEmail(developer.getEmail());
        RemainingMoneyDO rm = new RemainingMoneyDO(true);
        rm.setDeveloperId(developer.getId());
        rm.setMoney(Integer.valueOf(0));
        rm.setVersion(Long.valueOf(0L));
        Integer newMoney = rm.getMoney();
        Long newVersion = rm.getVersion();
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + newMoney.toString() + newVersion + newModifedStr));
        rm.setSign(newSign);
        this.remainingMoneyDao.insert(rm);
    }

    @Override
    public DeveloperDO findByEmail(String email) {
        return this.developerDao.findByEmail(email);
    }

    @Override
    public DeveloperDO find(Long id) {
        DeveloperDO d = (DeveloperDO)this.cacheClient.get(this.getCacheKeyById(id));
        if (d == null) {
            d = this.developerDao.find(id);
            this.cacheClient.set(this.getCacheKeyById(id), (Object)d, 300);
        }
        return d;
    }

    @Override
    public List<DeveloperDO> findByEmailLike(String email) {
        return this.developerDao.findByEmailLike(email);
    }

    @Override
    public List<DeveloperDO> findAllByIdList(List<Long> idList) {
        return this.developerDao.findAllByIdList(idList);
    }

    @Override
    public List<DeveloperDO> findDeveloperPage(ADeveloperQueryEntity queryEntity) {
        return this.developerDao.findDeveloperPage(queryEntity);
    }

    @Override
    public Long findDeveloperPageCount(ADeveloperQueryEntity queryEntity) {
        return this.developerDao.findDeveloperPageCount(queryEntity);
    }

    @Override
    public void insert(DeveloperDO developerDO) {
        this.developerDao.insert(developerDO);
    }

    @Override
    public int updateDeveloperSwitch(Long id, Integer developerSwitch) {
        int ret = this.developerDao.updateDeveloperSwitch(id, developerSwitch);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateLastRemindTime(Long id, Date lastRemindTime) {
        int ret = this.developerDao.updateLastRemindTime(id, lastRemindTime);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateRemindMoneyNameCompany(Long id, Integer remindMoney, String name, String company) {
        int ret = this.developerDao.updateRemindMoneyNameCompany(id, remindMoney, name, company);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updatePassword(Long id, String password) {
        int ret = this.developerDao.updatePassword(id, password);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateVerifyAndEnable(Long id, boolean verify, boolean enable) {
        int ret = this.developerDao.updateVerifyAndEnable(id, verify, enable);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }
}

