/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.dao.credits.developer.impl;

import cn.com.duiba.service.dao.BaseDao;
import cn.com.duiba.service.dao.DatabaseSchema;
import cn.com.duiba.service.dao.credits.developer.RemainingMoneyDao;
import cn.com.duiba.service.domain.dataobject.RemainingMoneyDO;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class RemainingMoneyDaoImpl
extends BaseDao
implements InitializingBean,
RemainingMoneyDao {
    @Value(value="#{configProperties['app.balance.sign']}")
    private Boolean enable;
    @Value(value="#{configProperties['app.balance.key']}")
    private String privateKey;

    @Override
    public void insert(RemainingMoneyDO rm) {
        this.insert("insert", rm);
    }

    @Override
    public RemainingMoneyDO findByDeveloperId(Long developerId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("developerId", developerId);
        return (RemainingMoneyDO)this.selectOne("findByDeveloperId", paramMap);
    }

    @Override
    public RemainingMoneyDO findByDeveloperId4update(Long developerId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("developerId", developerId);
        return (RemainingMoneyDO)this.selectOne("findByDeveloperId4update", paramMap);
    }

    @Override
    public int reduceMoney(Long id, Integer money, RemainingMoneyDO rm) throws Exception {
        if (id.longValue() != rm.getId().longValue()) {
            throw new RuntimeException("id \u4e0d\u4e00\u81f4");
        }
        if (this.enable.booleanValue() && rm.getMoney() != 0) {
            String modifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(rm.getGmtModified());
            String lastSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + rm.getMoney().toString() + rm.getVersion() + modifedStr));
            if (!lastSign.equals(rm.getSign())) {
                throw new StatusException(19);
            }
        }
        Integer newMoney = rm.getMoney() - money;
        Long newVersion = rm.getVersion() + 1L;
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + newMoney.toString() + newVersion + newModifedStr));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", rm.getId());
        paramMap.put("money", money);
        paramMap.put("version", rm.getVersion());
        paramMap.put("sign", newSign);
        paramMap.put("modified", newModified);
        int rows = this.update("reduceMoney", paramMap);
        if (rows < 1) {
            throw new RuntimeException("\u7248\u672c\u8fc7\u671f");
        }
        return rows;
    }

    @Override
    public int addMoney(Long id, Integer money, RemainingMoneyDO rm) throws Exception {
        if (id.longValue() != rm.getId().longValue()) {
            throw new RuntimeException("id \u4e0d\u4e00\u81f4");
        }
        if (this.enable.booleanValue() && rm.getMoney() != 0) {
            String modifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(rm.getGmtModified());
            String lastSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + rm.getMoney().toString() + rm.getVersion() + modifedStr));
            if (!lastSign.equals(rm.getSign())) {
                throw new StatusException(19);
            }
        }
        Integer newMoney = rm.getMoney() + money;
        Long newVersion = rm.getVersion() + 1L;
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + newMoney.toString() + newVersion + newModifedStr));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", rm.getId());
        paramMap.put("money", money);
        paramMap.put("version", rm.getVersion());
        paramMap.put("sign", newSign);
        paramMap.put("modified", newModified);
        int rows = this.update("addMoney", paramMap);
        if (rows < 1) {
            throw new RuntimeException("\u7248\u672c\u8fc7\u671f");
        }
        return rows;
    }

    @Override
    public int paybackMoney(Long id, Integer money, RemainingMoneyDO rm) throws Exception {
        if (id.longValue() != rm.getId().longValue()) {
            throw new RuntimeException("id \u4e0d\u4e00\u81f4");
        }
        if (this.enable.booleanValue() && rm.getMoney() != 0) {
            String modifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(rm.getGmtModified());
            String lastSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + rm.getMoney().toString() + rm.getVersion() + modifedStr));
            if (!lastSign.equals(rm.getSign())) {
                throw new StatusException(19);
            }
        }
        Integer newMoney = rm.getMoney() + money;
        Long newVersion = rm.getVersion() + 1L;
        Date newModified = new Date();
        String newModifedStr = new SimpleDateFormat("yyyyMMddHHmmss").format(newModified);
        String newSign = SecurityUtils.encode2StringByMd5((String)(this.privateKey + newMoney.toString() + newVersion + newModifedStr));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", rm.getId());
        paramMap.put("money", money);
        paramMap.put("version", rm.getVersion());
        paramMap.put("sign", newSign);
        paramMap.put("modified", newModified);
        int rows = this.update("paybackMoney", paramMap);
        if (rows < 1) {
            throw new RuntimeException("\u7248\u672c\u8fc7\u671f");
        }
        return rows;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.privateKey == null) {
            throw new RuntimeException("\u4f59\u989d\u7b7e\u540d\u79c1\u6709key\u4e0d\u80fd\u4e3anull");
        }
    }

    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

