/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.dao.impl;

import cn.com.duiba.service.constants.DsConstants;
import cn.com.duiba.service.dao.BaseDao;
import cn.com.duiba.service.dao.DatabaseSchema;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.item.dao.AppItemDao;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class AppItemDaoImpl
extends BaseDao
implements AppItemDao {
    private static Logger log = LoggerFactory.getLogger(AppItemDaoImpl.class);

    @Override
    public List<Long> findIdsByOpenLotteryIds(List<Long> openOaIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("openOaIds", openOaIds);
        return this.selectList("findIdsByOpenLotteryIds", paramMap);
    }

    @Override
    public List<AppItemDO> findAllBySourceTypeAndRelationIdAndDeleted(Integer sourceType, Long sourceRelationId, Boolean deleted) {
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        paramMap.put("sourceType", sourceType);
        paramMap.put("sourceRelationId", sourceRelationId);
        paramMap.put("deleted", deleted);
        return this.selectList("findAllBySourceTypeAndRelationIdAndDeleted", paramMap);
    }

    @Override
    public List<AppItemDO> findAllDuibaActivityAppItem(List<Long> itemIds, Long appId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("itemIds", itemIds);
        paramMap.put("appId", appId);
        return this.selectList("findAllDuibaActivityAppItem", paramMap);
    }

    @Override
    public List<AppItemDO> findAllOwnerByTitleAndTypeAndAppId4ASL(String title, String type, Long appId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("title", title);
        paramMap.put("type", type);
        paramMap.put("appId", appId);
        return this.selectList("findAllOwnerByTitleAndTypeAndAppId4ASL", paramMap);
    }

    @Override
    public List<AppItemDO> findAllNotOwnerByTitleAndTypeAndAppId4ASL(String title, String type, Long appId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("title", title);
        paramMap.put("type", type);
        paramMap.put("appId", appId);
        return this.selectList("findAllNotOwnerByTitleAndTypeAndAppId4ASL", paramMap);
    }

    @Override
    public Long countRow(Map<String, Object> params) {
        return (Long)this.selectOne("countRow", params);
    }

    @Override
    public List<AppItemDO> findByLimit(Map<String, Object> params) {
        return this.selectList("findByLimit", params);
    }

    @Override
    public List<Long> findInvalidAppItemIds(Long appId, String subStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("subStatus", subStatus);
        return this.selectList("findInvalidAppItemIds", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByTypeAndIsOwnerAndStatus(String type, Boolean isOwner, String status) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", type);
        paramMap.put("isOwner", isOwner);
        paramMap.put("status", status);
        return this.selectList("findAllByTypeAndIsOwnerAndStatus", paramMap);
    }

    @Override
    public List<Long> selectHasUpItems(List<Long> ids, Long appId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("ids", ids);
        return this.selectList("selectHasUpItems", paramMap);
    }

    @Override
    public AppItemDO selectItemStore(Long appId, Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        paramMap.put("itemId", itemId);
        return (AppItemDO)this.selectOne("selectItemStore", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByAppIdAndTypeIn(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.selectList("findAllByAppIdAndTypeIn", paramMap);
    }

    @Override
    public List<AppItemDO> findAllUpVirtaulAppItems(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.selectList("findAllUpVirtaulAppItems", paramMap);
    }

    @Override
    public List<AppItemDO> findAllVirtualValid(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.selectList("findAllVirtualValid", paramMap);
    }

    @Override
    public List<AppItemDO> findhomeAppItemNeed(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.selectList("findhomeAppItemNeed", paramMap);
    }

    @Override
    public List<AppItemDO> findhomeAppItemNeedOfPptv(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.selectList("findhomeAppItemNeedOfPptv", paramMap);
    }

    @Override
    public List<AppItemDO> findAllAppTasksContent(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.selectList("findAllAppTasksContent", paramMap);
    }

    @Override
    public AppItemDO selectItemStore4Task(Long appId, Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        paramMap.put("itemId", itemId);
        return (AppItemDO)this.selectOne("selectItemStore4Task", paramMap);
    }

    @Override
    public List<Long> findAppIdsByInActivityId(Long activityId, Integer type) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return this.selectList("findAppIdsByInActivityId", paramMap);
    }

    @Override
    public List<Long> findAppIdsByActivityId(Long relationId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("relationId", relationId);
        return this.selectList("findAppIdsByActivityId", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByItemIdsAndAppId(List<Long> itemIds, Long appId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("itemIds", itemIds);
        paramMap.put("appId", appId);
        return this.selectList("findAllByItemIdsAndAppId", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.selectList("findAllByIds", paramMap);
    }

    @Override
    public AppItemDO findByAppAndItemOnline(Long appId, Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        paramMap.put("itemId", itemId);
        return (AppItemDO)this.selectOne("findByAppAndItemOnline", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("itemId", itemId);
        return this.selectList("findAllByItemId", paramMap);
    }

    @Override
    public AppItemDO findByAppIdAndItemId(Long appId, Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        paramMap.put("itemId", itemId);
        return (AppItemDO)this.selectOne("findByAppIdAndItemId", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByAppIdAndType(Long appId, String type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("type", type);
        return this.selectList("findAllByAppIdAndType", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByAppIdAndInType(Long appId, String[] type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appId", appId);
        paramMap.put("type", type);
        return this.selectList("findAllByAppIdAndInType", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByInType(String[] type) {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        paramMap.put("type", type);
        return this.selectList("findAllByInType", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByAppAndIsOwner(Long appId, Boolean isOwner) {
        HashMap<String, Constable> paramMap = new HashMap<String, Constable>();
        paramMap.put("appId", appId);
        paramMap.put("isOwner", isOwner);
        return this.selectList("findAllByAppAndIsOwner", paramMap);
    }

    @Override
    public Integer findCountByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("itemId", itemId);
        return (Integer)this.selectOne("findCountByItemId", paramMap);
    }

    @Override
    public Integer findOnlineCount(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return (Integer)this.selectOne("findOnlineCount", paramMap);
    }

    @Override
    public AppItemDO find(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (AppItemDO)this.selectOne("find", paramMap);
    }

    @Override
    public void insert(AppItemDO appItem) {
        this.insert("insert", appItem);
    }

    @Override
    public void update(AppItemDO appItem) {
        this.update("update", appItem);
    }

    @Override
    public List<AppItemDO> findOnShelfByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("itemId", itemId);
        return this.selectList("findOnShelfByItemId", paramMap);
    }

    @Override
    public List<Long> findAppIdByItemIds(List<Long> itemIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("itemIds", itemIds);
        return this.selectList("findAppIdByItemIds", paramMap);
    }

    @Override
    public Long findAppItemIdByRelationId(Long sourceRelationId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("sourceRelationId", sourceRelationId);
        return (Long)this.selectOne("findAppItemIdByRelationId", paramMap);
    }

    @Override
    public List<Long> findAppItemIdByActivity(Long activityId, Integer type) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return this.selectList("findAppItemIdByActivity", paramMap);
    }

    @Override
    public List<Long> findAppIdsByIds(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        return this.selectList("findAppIdsByIds", paramMap);
    }

    @Override
    public AppItemDO findForUpdate(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (AppItemDO)this.selectOne("findForUpdate", paramMap);
    }

    @Override
    public List<AppItemDO> findSelfOverdueAppItem(String type) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(new Date());
        cal1.add(5, -7);
        Date startTime = cal1.getTime();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", type);
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", new Date());
        return this.selectList("findSelfOverdueAppItem", paramMap);
    }

    @Override
    public List<AppItemDO> findAutoOffAppItem() {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(new Date());
        cal1.add(5, -1);
        Date startTime = cal1.getTime();
        HashMap<String, Date> paramMap = new HashMap<String, Date>();
        paramMap.put("startTime", startTime);
        paramMap.put("endTime", new Date());
        return this.selectList("findAutoOffAppItem", paramMap);
    }

    @Override
    public List<AppItemDO> findAllAppItem(Map<String, Object> param) {
        return this.selectList("findAllAppItem", param);
    }

    @Override
    public List<AppItemDO> findAppItemLimit(Map<String, Object> param, int start, int pageSize) {
        param.put("start", start);
        param.put("pageSize", pageSize);
        return this.selectList("findAppItemLimit", param);
    }

    @Override
    public Long findAppItemCount(Map<String, Object> param) {
        return (Long)this.selectOne("findAppItemCount", param);
    }

    @Override
    public List<AppItemDO> findAllByAppId(Long appId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appId", appId);
        return this.selectList("findAllByAppId", paramMap);
    }

    @Override
    public List<AppItemDO> findAllByExpressTemplateId(Long expressTemplateId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("expressTemplateId", expressTemplateId);
        return this.selectList("findAllByExpressTemplateId", paramMap);
    }

    @Override
    public Long countPublishItemRow(Map<String, Object> queryPublish) {
        return (Long)this.selectOne("countPublishItemRow", queryPublish);
    }

    @Override
    public List<AppItemDO> findPublishItemLimit(Map<String, Object> queryPublish) {
        return this.selectList("findPublishItemLimit", queryPublish);
    }

    @Override
    public Integer updateStatusByActivityId(String status, Boolean delete, Long activityId, Integer type) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("status", status);
        paramMap.put("delete", delete);
        paramMap.put("activityId", activityId);
        paramMap.put("type", type);
        return this.update("updateStatusByActivityId", paramMap);
    }

    @Override
    public Integer updateStatusByOperationActivityId(String status, Boolean delete, Long relationId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("status", status);
        paramMap.put("delete", delete);
        paramMap.put("relationId", relationId);
        return this.update("updateStatusByOperationActivityId", paramMap);
    }

    @Override
    public int reduceRemaining(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        return this.update("reduceRemaining", paramMap);
    }

    @Override
    public int increaseRemaining(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        return this.update("increaseRemaining", paramMap);
    }

    @Override
    public void turnbackAppitemRemaining(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        this.update("turnbackAppitemRemaining", paramMap);
    }

    @Override
    public void decreaseAppitemRemaining(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        this.update("decreaseAppitemRemaining", paramMap);
    }

    @Override
    public void updateBatchIdById(Long id, Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        paramMap.put("batchId", batchId);
        this.update("updateBatchIdById", paramMap);
    }

    @Override
    public void standUpOrDownAppItem(Long id, String status, Boolean deleted, Integer payload, Boolean homeDisplay) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", status);
        paramMap.put("deleted", deleted);
        paramMap.put("payload", payload);
        paramMap.put("homeDisplay", homeDisplay);
        this.update("standUpOrDownAppItem", paramMap);
    }

    @Override
    public void deleteOrRecoverAppItem(Long id, Boolean deleted, String status) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("deleted", deleted);
        paramMap.put("status", status);
        this.update("deleteOrRecoverAppItem", paramMap);
    }

    @Override
    public void updateCreditsById(Long id, Long credits) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        paramMap.put("credits", credits);
        this.update("updateCreditsById", paramMap);
    }

    @Override
    public void updateRemainingById(Long id, Integer remaining) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("remaining", remaining);
        this.update("updateRemainingById", paramMap);
    }

    @Override
    public int updateStatusAndSubStatusById(Long id, String status, String subStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("status", status);
        paramMap.put("subStatus", subStatus);
        return this.update("updateStatusAndSubStatusById", paramMap);
    }

    @Override
    public void updateCreditsAndCustomPriceById(Long id, Long credits, String customPrice) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("credits", credits);
        paramMap.put("customPrice", customPrice);
        this.update("updateCreditsAndCustomPriceById", paramMap);
    }

    @Override
    public int updateStatusAndSubStatusByItemId(Long itemId, String status, String subStatus) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("itemId", itemId);
        paramMap.put("status", status);
        paramMap.put("subStatus", subStatus);
        return this.update("updateStatusAndSubStatusByItemId", paramMap);
    }

    @Override
    public int subRemainingById(Long id, Integer subRemaining) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("subRemaining", subRemaining);
        return this.update("subRemainingById", paramMap);
    }

    @Override
    public int addRemainingById(Long id, Integer addRemaining) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("addRemaining", addRemaining);
        return this.update("addRemainingById", paramMap);
    }

    @Override
    public void deletePushAppItem(List<Long> ids) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("ids", ids);
        this.update("deletePushAppItem", paramMap);
    }

    @Override
    public void updateExpiedAppItem(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("itemId", itemId);
        this.update("updateExpiedAppItem", paramMap);
    }

    @Override
    public void setMyRepoMultiNull(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        this.update("setMyRepoMultiNull", paramMap);
    }

    @Override
    public void setLimitNull(Long appItemId, Integer limitCount, String limitTimeBetween, Integer limitEverydayQuantity) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appItemId", appItemId);
        paramMap.put("limitCount", limitCount);
        paramMap.put("limitTimeBetween", limitTimeBetween);
        paramMap.put("limitEverydayQuantity", limitEverydayQuantity);
        this.update("setLimitNull", paramMap);
    }

    @Override
    public void setImageNull(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        this.update("setImageNull", paramMap);
    }

    @Override
    public void setSubStatusNull(Long appItemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        this.update("setSubStatusNull", paramMap);
    }

    @Override
    public void updateMainPushAppItem(Long id, String title, String logo, String smallImage, String whiteImage, String bannerImage, Long credits, String subtitle) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("title", title);
        paramMap.put("logo", logo);
        paramMap.put("smallImage", smallImage);
        paramMap.put("whiteImage", whiteImage);
        paramMap.put("bannerImage", bannerImage);
        paramMap.put("credits", credits);
        paramMap.put("subtitle", subtitle);
        this.update("updateMainPushAppItem", paramMap);
    }

    @Override
    public void updateHdtoolAppItem(Long id, String title, String smallImage, String whiteImage, Long credits, String customPrice, String logo) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("title", title);
        paramMap.put("smallImage", smallImage);
        paramMap.put("whiteImage", whiteImage);
        paramMap.put("credits", credits);
        paramMap.put("customPrice", customPrice);
        paramMap.put("logo", logo);
        this.update("updateHdtoolAppItem", paramMap);
    }

    @Override
    public void updateAppItemSourceType(Long id, Long credits, Date gmtModified, Integer sourceType, String title) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("credits", credits);
        paramMap.put("gmtModified", gmtModified);
        paramMap.put("sourceType", sourceType);
        paramMap.put("title", title);
        this.update("updateAppItemSourceType", paramMap);
    }

    @Override
    public void updateValidEndDate(Long id, Date validEndDate) {
        HashMap<String, Comparable<Long>> paramMap = new HashMap<String, Comparable<Long>>();
        paramMap.put("id", id);
        paramMap.put("validEndDate", validEndDate);
        this.update("updateValidEndDate", paramMap);
    }

    @Override
    public void updateCustomPrice(Long id, String customPrice) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("customPrice", customPrice);
        this.update("updateCustomPrice", paramMap);
    }

    @Override
    public void updateOperationsTypeById(Long id, Integer operationsType) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("operationsType", operationsType);
        this.update("updateOperationsTypeById", paramMap);
    }

    @Override
    public void updateActivityAppItem(Long id, String title, String subtitle, String logo, String smallImage, String whiteImage) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("title", title);
        paramMap.put("subtitle", subtitle);
        paramMap.put("logo", logo);
        paramMap.put("smallImage", smallImage);
        paramMap.put("whiteImage", whiteImage);
        this.update("updateActivityAppItem", paramMap);
    }

    @Override
    public void updateTurntableAppItem(Long id, String title, String subtitle, String logo, String smallImage, String whiteImage, Long credits, String customPrice) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("id", id);
        paramMap.put("title", title);
        paramMap.put("subtitle", subtitle);
        paramMap.put("logo", logo);
        paramMap.put("smallImage", smallImage);
        paramMap.put("whiteImage", whiteImage);
        paramMap.put("credits", credits);
        paramMap.put("customPrice", customPrice);
        this.update("updateTurntableAppItem", paramMap);
    }

    @Override
    public int updateSubTypeById(Long id, Integer subType) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", id);
        paramMap.put("subType", subType);
        return this.update("updateSubTypeById", paramMap);
    }

    @Override
    public int updateRemainingAndvalidEndDate(Long id, Integer remaining, Date validEndDate) {
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        paramMap.put("id", id);
        paramMap.put("remaining", remaining);
        paramMap.put("validEndDate", validEndDate);
        return this.update("updateRemainingAndvalidEndDate", paramMap);
    }

    @Override
    public int updateExpiedAppItemById(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.update("updateExpiedAppItemById", paramMap);
    }

    @Override
    public int updateAutoOffDateNull(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.update("updateAutoOffDateNull", paramMap);
    }

    @Override
    public List<AppItemDO> findIdAndAppId4AppItem(List<Long> appItemIds) {
        if (appItemIds.size() == 0) {
            return Collections.emptyList();
        }
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("appItemIds", appItemIds);
        return this.selectList("findIdAndAppId4AppItem", param);
    }

    @Override
    public int updateAppItemPayload(Long appId, Long appItemId, Integer payload) throws Exception {
        int num;
        if (payload > DsConstants.ITEM_TOP_START && (num = this.getTopNumByAppId(appId)) > DsConstants.ITEM_TOP_NUM) {
            StringBuffer sb = new StringBuffer();
            sb.append("AppId:").append(appId).append("\u5728\u7f6e\u9876\u6570\u4e3a").append(num).append("\u7684\u60c5\u51b5\u4e0b\u5c06AppItemId:").append(appItemId).append("\u8fdb\u884c\u7f6e\u9876");
            log.error(sb.toString());
            throw new Exception("\u7f6e\u9876\u6570\u5df2\u7ecf\u8d85\u9650\uff0c\u65e0\u6cd5\u6267\u884c\u7f6e\u9876");
        }
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("appItemId", appItemId);
        param.put("payload", payload);
        int ret = this.update("updateAppItemPayload", param);
        return ret;
    }

    @Override
    public int getTopNumByAppId(Long appId) {
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("appId", appId);
        param.put("topStart", DsConstants.ITEM_TOP_START);
        int num = (Integer)this.selectOne("getTopNumByAppId", param);
        return num;
    }

    @Override
    public int findAppMaxPayload(Long appId) {
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("appId", appId);
        param.put("topStart", DsConstants.ITEM_TOP_START);
        int payload = (Integer)this.selectOne("findAppMaxPayload", param);
        if (payload > DsConstants.ITEM_TOP_START) {
            log.error(new StringBuffer().append("appId:").append(appId).append("\u83b7\u53d6\u6743\u91cd\u65f6\u51fa\u73b0\u5f02\u5e38").toString());
            throw new RuntimeException("\u6743\u91cd\u5206\u914d\u5f02\u5e38");
        }
        return payload;
    }

    @Override
    public List<Long> findTopAppItemDesc(Long appId) {
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("appId", appId);
        param.put("topStart", DsConstants.ITEM_TOP_START);
        return this.selectList("findTopAppItemDesc", param);
    }

    @Override
    public int updateOfflineAppItem4Disable(Long appId) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("appId", appId);
        int ret = this.update("updateOfflineAppItem4Disable", param);
        return ret;
    }

    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

