/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.core.Environment;
import cn.com.duiba.service.domain.dataobject.AppDO;
import cn.com.duiba.service.domain.dataobject.AppItemDO;
import cn.com.duiba.service.domain.dataobject.DuibaHdtoolDO;
import cn.com.duiba.service.domain.dataobject.DuibaQuestionAnswerDO;
import cn.com.duiba.service.domain.dataobject.DuibaQuizzDO;
import cn.com.duiba.service.domain.dataobject.DuibaSeckillDO;
import cn.com.duiba.service.domain.dataobject.DuibaSecondsKillActivityDO;
import cn.com.duiba.service.domain.dataobject.GameConfigDuibaDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.AppItemBo;
import cn.com.duiba.service.item.domain.dataobject.DuibaActivityDO;
import cn.com.duiba.service.item.domain.dataobject.DuibaSingleLotteryDO;
import cn.com.duiba.service.item.domain.dataobject.DuibaTurntableDO;
import cn.com.duiba.service.item.domain.dataobject.ItemAppSpecifyDO;
import cn.com.duiba.service.item.domain.dataobject.OperatingActivityDO;
import cn.com.duiba.service.item.domain.vo.ActivityVO;
import cn.com.duiba.service.item.event.DuibaEventsDispatcher;
import cn.com.duiba.service.item.event.ItemEvent;
import cn.com.duiba.service.item.service.AppItemClassifyService;
import cn.com.duiba.service.item.service.AppItemExtraService;
import cn.com.duiba.service.item.service.AppItemService;
import cn.com.duiba.service.item.service.DuibaSingleLotteryService;
import cn.com.duiba.service.item.service.DuibaTurntableService;
import cn.com.duiba.service.item.service.ItemAppSpecifyService;
import cn.com.duiba.service.item.service.ItemKeyService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.service.OperatingActivityService;
import cn.com.duiba.service.service.AppBannerService;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.service.service.DuibaActivityService;
import cn.com.duiba.service.service.DuibaHdtoolService;
import cn.com.duiba.service.service.DuibaQuestionAnswerService;
import cn.com.duiba.service.service.DuibaQuizzService;
import cn.com.duiba.service.service.DuibaSeckillService;
import cn.com.duiba.service.service.DuibaSecondsKillActivityService;
import cn.com.duiba.service.service.GameConfigDuibaService;
import cn.com.duiba.service.tools.TypeConstant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppItemBoImpl
implements AppItemBo {
    private static final Logger log = LoggerFactory.getLogger(AppItemBoImpl.class);
    @Resource
    private AppItemService appItemService;
    @Resource
    private AppItemExtraService appItemExtraService;
    @Resource
    private ItemAppSpecifyService itemAppSpecifyService;
    @Resource
    private ItemKeyService itemKeyService;
    @Resource
    private OperatingActivityService operatingActivityService;
    @Resource
    private AppBannerService appBannerService;
    @Resource
    private AppItemClassifyService appItemClassifyService;
    @Resource
    private ItemService itemService;
    @Resource
    private DuibaTurntableService duibaTurntableService;
    @Resource
    private DuibaSingleLotteryService duibaSingleLotteryService;
    @Resource
    private DuibaActivityService duibaActivityService;
    @Resource
    private DuibaHdtoolService duibaHdtoolService;
    @Resource
    private GameConfigDuibaService gameConfigDuibaService;
    @Resource
    private DuibaQuizzService duibaQuizzService;
    @Resource
    private DuibaSecondsKillActivityService duibaSecondsKillActivityService;
    @Resource
    private DuibaQuestionAnswerService duibaQuestionAnswerService;
    @Resource
    private DuibaSeckillService duibaSeckillService;
    @Resource
    private AppService appService;

    @Override
    @Transactional(value="credits")
    public void saveAppItemByTurntable(AppItemDO appItem, long turntableId) {
        boolean notify = false;
        if (appItem.getId() == null) {
            notify = true;
        } else {
            AppItemDO a = this.appItemService.find(appItem.getId());
            if (a.getDeleted() != appItem.getDeleted()) {
                notify = true;
            }
        }
        this.saveAppItemByTurntableNoTranscation(appItem, turntableId);
        if (notify) {
            this.notify(this.itemKeyService.getItemKey(null, appItem.getId(), appItem.getAppId()));
        }
    }

    @Override
    public void saveAppItemByTurntableNoTranscation(AppItemDO appItem, long turntableId) {
        OperatingActivityDO activity = this.operatingActivityService.find(turntableId);
        if (activity == null) {
            throw new NullPointerException("OperatingActivity is null");
        }
        appItem.setType("fake");
        appItem.setIsOwner(Boolean.valueOf(true));
        appItem.setCredits(activity.getCredits());
        appItem.setStatus(appItem.getDeleted() != false ? "off" : "on");
        appItem.setHomeDisplay(Boolean.valueOf(true));
        appItem.setAddTime(new Date());
        if (activity.getType() == 1) {
            appItem.setSourceType(Integer.valueOf(1));
        } else if (activity.getType() == 4) {
            DuibaTurntableDO dt = this.duibaTurntableService.find(activity.getActivityId());
            appItem.setCredits(Long.valueOf(dt.getCreditsPrice().longValue()));
            appItem.setCustomPrice("duiba");
            appItem.setSourceType(Integer.valueOf(1));
        } else if (activity.getType() == DuibaActivityDO.TYPE_ACTIVITY) {
            appItem.setSourceType(Integer.valueOf(2));
        } else if (activity.getType() == 2) {
            DuibaSingleLotteryDO ds = this.duibaSingleLotteryService.find(activity.getActivityId());
            appItem.setCredits(Long.valueOf(ds.getCreditsPrice().longValue()));
            appItem.setCustomPrice("duiba");
            appItem.setSourceType(Integer.valueOf(3));
        } else if (activity.getType() == 3) {
            appItem.setSourceType(Integer.valueOf(3));
        } else if (activity.getType() == 5) {
            appItem.setSourceType(Integer.valueOf(4));
        } else if (activity.getType() == 6) {
            appItem.setSourceType(Integer.valueOf(7));
        } else if (activity.getType() == 7) {
            appItem.setSourceType(Integer.valueOf(8));
        } else if (activity.getType() == 9) {
            appItem.setSourceType(Integer.valueOf(9));
        } else if (activity.getType() == 8) {
            appItem.setSourceType(Integer.valueOf(10));
        } else if (activity.getType() == 20) {
            appItem.setSourceType(Integer.valueOf(20));
        } else if (activity.getType() == 22) {
            appItem.setSourceType(Integer.valueOf(22));
        } else if (activity.getType() == 21) {
            appItem.setSourceType(Integer.valueOf(21));
        } else if (activity.getType() == 30) {
            appItem.setSourceType(Integer.valueOf(11));
        } else if (activity.getType() == 40) {
            appItem.setSourceType(Integer.valueOf(30));
        } else if (activity.getType() == 41) {
            appItem.setSourceType(Integer.valueOf(41));
        } else if (activity.getType() == 31) {
            appItem.setSourceType(Integer.valueOf(40));
        } else {
            appItem.setSourceType(Integer.valueOf(0));
        }
        appItem.setSourceRelationId(activity.getId());
        if (appItem.getDeleted().booleanValue()) {
            appItem.setPayload(Integer.valueOf(0));
        } else {
            appItem.setPayload(Integer.valueOf(this.appItemService.findAppMaxPayload(activity.getAppId()) + 1));
        }
        appItem.setExchangeTipTemplate("");
        this.appItemService.insert(appItem);
        activity.setAppItemId(appItem.getId());
        activity.setGmtModified(new Date());
        OperatingActivityDO activity4u = new OperatingActivityDO(activity.getId());
        activity4u.setAppItemId(activity.getAppItemId());
        activity4u.setGmtModified(activity.getGmtModified());
        activity4u.setStatus(activity.getStatus());
        this.operatingActivityService.update(activity4u);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", activity.getAppId());
        map.put("parentId", activity.getId());
        List<ActivityVO> childActivity = this.operatingActivityService.findActivityList(map);
        for (ActivityVO child : childActivity) {
            OperatingActivityDO childoa = new OperatingActivityDO(child.getId());
            childoa.setStatus(activity.getStatus());
            this.operatingActivityService.update(childoa);
        }
    }

    @Override
    @Transactional(value="credits")
    public void standUpOrDown(Long appId, Long appItemId, String status) throws BusinessException {
        AppItemDO appItem = this.appItemService.find(appItemId);
        appItem.setStatus(status);
        if (status.equals("off")) {
            this.appBannerService.disableByAppIdAndAppItemId(appId, appItemId);
            if (appItem.getType().equals("turntable") || appItem.getType().equals("fake")) {
                appItem.setDeleted(Boolean.valueOf(true));
            }
            appItem.setPayload(Integer.valueOf(0));
        } else if (status.equals("on")) {
            int maxPayload = this.appItemService.findAppMaxPayload(appId);
            appItem.setPayload(Integer.valueOf(maxPayload + 1));
            appItem.setHomeDisplay(Boolean.valueOf(true));
            if (appItem.getItemId() != null && ("coupon".equals(appItem.getType()) || "object".equals(appItem.getType()))) {
                ItemDO item = this.itemService.find(appItem.getItemId());
                if (item.getAutoOffDate() != null && item.getAutoOffDate().before(new Date())) {
                    throw new BusinessException("\u5df2\u8fc7\u81ea\u52a8\u4e0b\u67b6\u65f6\u95f4\u65e0\u6cd5\u4e0a\u67b6");
                }
                if (appItem.getAutoOffDate() != null && appItem.getAutoOffDate().before(new Date())) {
                    throw new BusinessException("\u5df2\u8fc7\u81ea\u52a8\u4e0b\u67b6\u65f6\u95f4\u65e0\u6cd5\u4e0a\u67b6");
                }
            } else if (appItem.getAutoOffDate() != null && appItem.getAutoOffDate().before(new Date())) {
                throw new BusinessException("\u5df2\u8fc7\u81ea\u52a8\u4e0b\u67b6\u65f6\u95f4\u65e0\u6cd5\u4e0a\u67b6");
            }
        } else {
            throw new BusinessException("\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        AppItemDO ai4u = new AppItemDO(appItem.getId());
        ai4u.setStatus(appItem.getStatus());
        ai4u.setDeleted(appItem.getDeleted());
        ai4u.setPayload(appItem.getPayload());
        ai4u.setHomeDisplay(appItem.getHomeDisplay());
        this.appItemService.standUpOrDownAppItem(ai4u.getId(), ai4u.getStatus(), ai4u.getDeleted(), ai4u.getPayload(), ai4u.getHomeDisplay());
        this.notify(this.itemKeyService.getItemKey(null, appItemId, appId));
    }

    @Override
    @Transactional(value="credits")
    public void deleteAppItem(Long appId, Long appItemId) {
        AppItemDO appItem = new AppItemDO(appItemId);
        appItem.setDeleted(Boolean.valueOf(true));
        appItem.setStatus("off");
        this.appItemService.deleteOrRecoverAppItem(appItem.getId(), appItem.getDeleted(), appItem.getStatus());
        this.appItemExtraService.deleteByAppItemId(appItem.getId());
        this.appBannerService.disableByAppIdAndAppItemId(appId, appItemId);
        this.appItemClassifyService.deleteRelationAppItem(appItemId);
        ItemKey key = this.itemKeyService.getItemKeyIncludeDeleted(null, appItemId, appId);
        DuibaEventsDispatcher.get().dispatchEvent(new ItemEvent(ItemEvent.ItemEventType.onDeleted, key));
    }

    private void notify(ItemKey itemKey) {
        if (itemKey.getAppItem() != null) {
            if ("on".equals(itemKey.getAppItem().getStatus())) {
                DuibaEventsDispatcher.get().dispatchEvent(new ItemEvent(ItemEvent.ItemEventType.onShelfOn, itemKey));
            } else if ("off".equals(itemKey.getAppItem().getStatus())) {
                DuibaEventsDispatcher.get().dispatchEvent(new ItemEvent(ItemEvent.ItemEventType.onShelfOff, itemKey));
            }
        }
    }

    @Override
    public AppItemDO saveAppItemByActivity(Long appId, String type, Boolean delete) {
        ItemDO item = this.itemService.findByType(type);
        AppItemDO appItem = this.appItemService.findByAppIdAndItemId(appId, item.getId());
        if (appItem == null) {
            appItem = new AppItemDO(true);
            appItem.setDeleted(delete);
            appItem.setAppId(appId);
            appItem.setItemId(item.getId());
            appItem.setStatus(delete != false ? "off" : "on");
            appItem.setAddTime(new Date());
            appItem.setTitle(item.getName());
            appItem.setSubtitle(item.getSubtitle());
            appItem.setCustomPrice(item.getCustomPrice());
            appItem.setCredits(null);
            appItem.setMinFacePrice(item.getMinFacePrice());
            appItem.setLogo(item.getLogo());
            if (delete.booleanValue()) {
                appItem.setPayload(Integer.valueOf(0));
            } else {
                appItem.setPayload(Integer.valueOf(this.appItemService.findAppMaxPayload(appId) + 1));
            }
            appItem.setIsOwner(Boolean.valueOf(false));
            appItem.setExchangeTipTemplate(item.getExchangeTipTemplate());
            appItem.setType(item.getType());
            this.appItemService.insert(appItem);
        }
        return appItem;
    }

    @Override
    public Integer getRemaining0Count(Long appId) {
        List<AppItemDO> ais = this.appItemService.findAllByAppIdAndTypeIn(appId);
        int sum = 0;
        HashMap<Long, ItemDO> itemMap = new HashMap<Long, ItemDO>();
        ArrayList<Long> itemIds = new ArrayList<Long>();
        for (AppItemDO ai : ais) {
            if (ai.getIsOwner().booleanValue() || ai.getItemId() == null) continue;
            itemIds.add(ai.getItemId());
        }
        List<Object> items = null;
        items = itemIds.size() > 0 ? this.itemService.findAllByIds(itemIds) : Collections.emptyList();
        for (ItemDO i : items) {
            itemMap.put(i.getId(), i);
        }
        HashMap<Long, ItemAppSpecifyDO> itemAppSpecifyMap = new HashMap<Long, ItemAppSpecifyDO>();
        ArrayList<Long> appSpecifyItemIds = new ArrayList<Long>();
        for (AppItemDO ai : ais) {
            ItemDO item;
            if (ai.getIsOwner().booleanValue() || (item = (ItemDO)itemMap.get(ai.getItemId())) == null || !item.isOpTypeItem(3)) continue;
            appSpecifyItemIds.add(item.getId());
        }
        List<Object> itemAppSpecifys = null;
        itemAppSpecifys = appSpecifyItemIds.size() > 0 ? this.itemAppSpecifyService.findSpecifyByItemIdsAndAppId(appSpecifyItemIds, appId) : Collections.emptyList();
        for (ItemAppSpecifyDO i : itemAppSpecifys) {
            itemAppSpecifyMap.put(i.getItemId(), i);
        }
        for (AppItemDO ai : ais) {
            ItemAppSpecifyDO ias;
            if (ai.getIsOwner().booleanValue()) {
                if (ai.getRemaining() != null && !Integer.valueOf(0).equals(ai.getRemaining())) continue;
                ++sum;
                continue;
            }
            ItemDO item = (ItemDO)itemMap.get(ai.getItemId());
            if (item == null || !item.getEnable().booleanValue() || TypeConstant.isChargeType((String)item.getType())) continue;
            if (Integer.valueOf(0).equals(item.getRemaining())) {
                ++sum;
                continue;
            }
            if (!item.isOpTypeItem(3) || (ias = (ItemAppSpecifyDO)itemAppSpecifyMap.get(item.getId())) == null) continue;
            Integer specifyRemaining = ias.getRemaining();
            if (!Integer.valueOf(0).equals(specifyRemaining)) continue;
            ++sum;
        }
        return sum;
    }

    @Override
    @Transactional(value="credits")
    public void updateAppItemByTurntable(AppItemDO appItem, long turntableId) throws BusinessException {
        boolean notify = false;
        if (appItem.getId() == null) {
            notify = true;
        } else {
            AppItemDO a = this.appItemService.find(appItem.getId());
            if (a.getDeleted() != appItem.getDeleted()) {
                notify = true;
            }
        }
        this.updateAppItemByTurntableNoTranscation(appItem, turntableId);
        if (notify) {
            this.notify(this.itemKeyService.getItemKey(null, appItem.getId(), appItem.getAppId()));
        }
    }

    @Override
    public void updateAppItemByTurntableNoTranscation(AppItemDO appItem, long turntableId) throws BusinessException {
        DuibaSeckillDO duibaSeckill;
        DuibaQuizzDO quizz;
        DuibaQuestionAnswerDO duibaQuestionAnswer;
        DuibaSecondsKillActivityDO duibaSecondsKillActivity;
        GameConfigDuibaDO gameConfigDuiba;
        DuibaHdtoolDO duibaHdtoolDO;
        DuibaTurntableDO dt;
        OperatingActivityDO activity = this.operatingActivityService.find(turntableId);
        if (activity == null) {
            throw new BusinessException("OperatingActivity is null");
        }
        if (!appItem.getDeleted().booleanValue() && (4 == activity.getType() ? 1 != (dt = this.duibaTurntableService.find(activity.getActivityId())).getStatus() : (0 == activity.getType() ? DuibaActivityDO.STATUS_STARTUP != (dt = this.duibaActivityService.find(activity.getActivityId())).getStatus() : (2 == activity.getType() ? DuibaSingleLotteryDO.STATUS_STARTUP != (dt = this.duibaSingleLotteryService.find(activity.getActivityId())).getStatus() : (6 == activity.getType() && activity.getActivityId() != null ? 1 != (duibaHdtoolDO = this.duibaHdtoolService.find(activity.getActivityId())).getStatus() : (7 == activity.getType() && activity.getActivityId() != null ? 1 != (duibaHdtoolDO = this.duibaHdtoolService.find(activity.getActivityId())).getStatus() : (9 == activity.getType() && activity.getActivityId() != null ? 1 != (duibaHdtoolDO = this.duibaHdtoolService.find(activity.getActivityId())).getStatus() : (8 == activity.getType() && activity.getActivityId() != null ? 1 != (duibaHdtoolDO = this.duibaHdtoolService.find(activity.getActivityId())).getStatus() : (20 == activity.getType() && activity.getActivityId() != null ? 1 != (gameConfigDuiba = this.gameConfigDuibaService.find(activity.getActivityId())).getStatus() : (22 == activity.getType() && activity.getActivityId() != null ? 1 != (gameConfigDuiba = this.gameConfigDuibaService.find(activity.getActivityId())).getStatus() : (21 == activity.getType() && activity.getActivityId() != null ? 1 != (gameConfigDuiba = this.gameConfigDuibaService.find(activity.getActivityId())).getStatus() : (30 == activity.getType() && activity.getActivityId() != null ? DuibaSecondsKillActivityDO.STATUS_STARTUP != (duibaSecondsKillActivity = this.duibaSecondsKillActivityService.find(activity.getActivityId())).getStatus() : (40 == activity.getType() && activity.getActivityId() != null ? 1 != (duibaQuestionAnswer = this.duibaQuestionAnswerService.find(activity.getActivityId())).getStatus() : (41 == activity.getType() && activity.getActivityId() != null ? 1 != (quizz = this.duibaQuizzService.find(activity.getActivityId())).getStatus() : 31 == activity.getType() && activity.getActivityId() != null && 1 != (duibaSeckill = this.duibaSeckillService.find(activity.getActivityId())).getStatus())))))))))))))) {
            throw new BusinessException("\u540e\u53f0\u5df2\u5173\u95ed\u65e0\u6cd5\u914d\u7f6e");
        }
        appItem.setTitle(activity.getTitle());
        appItem.setType("fake");
        appItem.setIsOwner(Boolean.valueOf(true));
        appItem.setCredits(activity.getCredits());
        appItem.setStatus(appItem.getDeleted() != false ? "off" : "on");
        appItem.setHomeDisplay(Boolean.valueOf(true));
        appItem.setAddTime(new Date());
        if (activity.getType() == 1) {
            appItem.setSourceType(Integer.valueOf(1));
        } else if (activity.getType() == 4) {
            dt = this.duibaTurntableService.find(activity.getActivityId());
            appItem.setCredits(Long.valueOf(dt.getCreditsPrice().longValue()));
            appItem.setCustomPrice("duiba");
            appItem.setSourceType(Integer.valueOf(1));
        } else if (activity.getType().intValue() == DuibaActivityDO.TYPE_ACTIVITY.intValue()) {
            appItem.setSourceType(Integer.valueOf(2));
        } else if (activity.getType() == 2) {
            DuibaSingleLotteryDO ds = this.duibaSingleLotteryService.find(activity.getActivityId());
            appItem.setCredits(Long.valueOf(ds.getCreditsPrice().longValue()));
            appItem.setCustomPrice("duiba");
            appItem.setSourceType(Integer.valueOf(3));
        } else if (activity.getType() == 3) {
            appItem.setSourceType(Integer.valueOf(3));
        } else if (activity.getType() == 5) {
            appItem.setSourceType(Integer.valueOf(4));
        } else if (activity.getType() == 6) {
            appItem.setSourceType(Integer.valueOf(7));
        } else if (activity.getType() == 7) {
            appItem.setSourceType(Integer.valueOf(8));
        } else if (activity.getType() == 9) {
            appItem.setSourceType(Integer.valueOf(9));
        } else if (activity.getType() == 8) {
            appItem.setSourceType(Integer.valueOf(10));
        } else if (activity.getType() == 20) {
            appItem.setSourceType(Integer.valueOf(20));
        } else if (activity.getType() == 22) {
            appItem.setSourceType(Integer.valueOf(22));
        } else if (activity.getType() == 21) {
            appItem.setSourceType(Integer.valueOf(21));
        } else if (activity.getType() == 30) {
            appItem.setSourceType(Integer.valueOf(11));
        } else if (activity.getType() == 40) {
            appItem.setSourceType(Integer.valueOf(30));
        } else if (activity.getType() == 41) {
            appItem.setSourceType(Integer.valueOf(41));
        } else if (activity.getType() == 31) {
            appItem.setSourceType(Integer.valueOf(40));
        } else {
            appItem.setSourceType(Integer.valueOf(0));
        }
        appItem.setSourceRelationId(activity.getId());
        if (appItem.getDeleted().booleanValue()) {
            appItem.setPayload(Integer.valueOf(0));
        } else {
            appItem.setPayload(Integer.valueOf(this.appItemService.findAppMaxPayload(activity.getAppId()) + 1));
        }
        appItem.setExchangeTipTemplate("");
        this.appItemService.update(appItem);
        activity.setAppItemId(appItem.getId());
        activity.setGmtModified(new Date());
        OperatingActivityDO activity4u = new OperatingActivityDO(activity.getId());
        activity4u.setAppItemId(activity.getAppItemId());
        activity4u.setGmtModified(activity.getGmtModified());
        activity4u.setStatus(activity.getStatus());
        this.operatingActivityService.update(activity4u);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appId", activity.getAppId());
        map.put("parentId", activity.getId());
        List<ActivityVO> childActivity = this.operatingActivityService.findActivityList(map);
        for (ActivityVO child : childActivity) {
            OperatingActivityDO childoa = new OperatingActivityDO(child.getId());
            childoa.setStatus(activity.getStatus());
            this.operatingActivityService.update(childoa);
        }
    }

    @Override
    public int bathcStandUp(AppDO app, List<Long> appItemIds) {
        if (appItemIds.isEmpty()) {
            return 0;
        }
        List<AppItemDO> ais = this.appItemService.findAllByIds(appItemIds);
        for (int i = ais.size() - 1; i >= 0; --i) {
            AppItemDO appItem = ais.get(i);
            if (!appItem.getAppId().equals(app.getId())) {
                ais.remove(i);
                continue;
            }
            if (!appItem.getType().equals("virtual") || !StringUtils.isBlank((String)app.getVirtualExchangeUrl())) continue;
            ais.remove(i);
        }
        int temp = 0;
        for (AppItemDO ai : ais) {
            if (!ai.getStatus().equals("off")) continue;
            int maxPayload = this.appItemService.findAppMaxPayload(app.getId());
            this.appItemService.standUpOrDownAppItem(ai.getId(), "on", false, maxPayload + 1, ai.getHomeDisplay());
            this.notify(this.itemKeyService.getItemKey(null, ai.getId(), app.getId()));
            ++temp;
        }
        return temp;
    }

    @Override
    public void addTestAppItem(Long appId) {
        ItemDO item = null;
        item = Environment.isDaily() || Environment.isDev() ? this.itemService.find(500L) : this.itemService.find(191L);
        Date today = new Date();
        AppItemDO appItem = new AppItemDO(true);
        appItem.setAppId(appId);
        appItem.setItemId(item.getId());
        appItem.setStatus("on");
        appItem.setAddTime(today);
        appItem.setTitle(item.getName());
        appItem.setSubtitle(item.getSubtitle());
        appItem.setCustomPrice(item.getCustomPrice());
        appItem.setCredits(null);
        appItem.setPayload(Integer.valueOf(this.appItemService.findAppMaxPayload(appId) + 1));
        appItem.setMinFacePrice(item.getMinFacePrice());
        appItem.setLogo(item.getLogo());
        appItem.setImage(item.getImage());
        appItem.setSmallImage(item.getSmallImage());
        appItem.setMultiImage(item.getMultiImage());
        appItem.setDeleted(Boolean.valueOf(false));
        appItem.setType(item.getType());
        appItem.setOperationsType(Integer.valueOf(0));
        appItem.setExchangeTipTemplate(item.getExchangeTipTemplate());
        appItem.setIsOwner(Boolean.valueOf(false));
        if (item.getValidEndDate() != null) {
            if (item.getValidEndDate().getTime() > today.getTime()) {
                appItem.setSubStatus(null);
            } else {
                appItem.setSubStatus("expired");
            }
        }
        this.appItemService.insert(appItem);
    }

    @Override
    public Long getOrAddAppItemId(Integer type, Long appId) {
        ItemDO item = null;
        AppItemDO appItem = null;
        String typeString = null;
        if (type == 1) {
            typeString = "alipay";
        } else if (type == 2) {
            typeString = "qb";
        } else if (type == 3) {
            typeString = "phonebill";
        }
        item = this.itemService.findByType(typeString);
        appItem = this.addItemToAppItem(item, appId, Boolean.TRUE);
        return appItem.getId();
    }

    private AppItemDO addItemToAppItem(ItemDO item, Long appId, Boolean deleted) {
        Date now = new Date();
        AppDO app = this.appService.find(appId);
        AppItemDO ai = this.appItemService.findByAppIdAndItemId(appId, item.getId());
        if (ai == null) {
            ai = new AppItemDO(true);
            ai.setAppId(appId);
            ai.setItemId(item.getId());
            ai.setDeleted(deleted);
            ai.setStatus("off");
            ai.setAddTime(now);
            ai.setTitle(item.getName());
            ai.setSubtitle(item.getSubtitle());
            ai.setCustomPrice(item.getCustomPrice());
            int minCredits = (int)((double)(item.getFacePrice() * app.getCreditsRate()) / 100.0);
            if (minCredits < 1) {
                minCredits = 1;
            }
            ai.setMinFacePrice(Integer.valueOf(minCredits));
            ai.setIsOwner(Boolean.valueOf(false));
            ai.setExchangeTipTemplate(item.getExchangeTipTemplate());
            ai.setType(item.getType());
            if (item.getValidEndDate() != null && item.getValidEndDate().getTime() <= now.getTime()) {
                ai.setSubStatus("expired");
            }
            ai.setCredits(null);
            ai.setPayload(Integer.valueOf(0));
            this.appItemService.insert(ai);
        }
        return ai;
    }

    @Override
    @Transactional(value="credits")
    public int sortClassifyAppItem(Long classifyId, List<Long> appItemIds) {
        int sortNum = 0;
        Integer maxPayload = this.appItemClassifyService.findMaxPayload(classifyId);
        if (maxPayload == null || maxPayload <= appItemIds.size()) {
            maxPayload = appItemIds.size();
        }
        Integer tempPayload = maxPayload;
        for (Long appItemId : appItemIds) {
            int ret = this.appItemClassifyService.updatePayload(appItemId, classifyId, tempPayload);
            tempPayload = tempPayload - 1;
            sortNum += ret;
        }
        return sortNum;
    }
}

