/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.SingleLotteryStockManualChangeDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.SingleLotteryMainOperateBo;
import cn.com.duiba.service.item.domain.dataobject.DuibaSingleLotteryDO;
import cn.com.duiba.service.item.service.DuibaSingleLotteryService;
import cn.com.duiba.service.service.SingleLotteryService;
import cn.com.duiba.service.service.SingleLotteryStockManualChangeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SingleLotteryMainOperateBoImpl
implements SingleLotteryMainOperateBo {
    private static final Logger log = LoggerFactory.getLogger(SingleLotteryMainOperateBoImpl.class);
    @Autowired
    private SingleLotteryService singleLotteryService;
    @Autowired
    private DuibaSingleLotteryService duibaSingleLotteryService;
    @Autowired
    private SingleLotteryStockManualChangeService singleLotteryStockManualChangeService;

    @Override
    @Transactional(value="credits")
    public boolean addSingleLotteryMainStockQuantity(Long optionId, Integer quantity) throws BusinessException {
        Integer remaing = this.singleLotteryService.findRemaingForupdate(optionId);
        if (null == remaing) {
            throw new BusinessException("\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.singleLotteryService.addMainAppItemRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u53d8\u66f4\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        SingleLotteryStockManualChangeDO singleStockChange = new SingleLotteryStockManualChangeDO(true);
        singleStockChange.setRelationId(optionId);
        singleStockChange.setRelationType("app");
        singleStockChange.setBeforeStock(Long.valueOf(remaing.intValue()));
        singleStockChange.setAfterStock(Long.valueOf(remaing + quantity));
        singleStockChange.setChangeKind("add");
        singleStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        singleStockChange.setOptionType("main");
        this.singleLotteryStockManualChangeService.insert(singleStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean reduceSingleLotteryMainStockQuantity(Long optionId, Integer quantity) throws BusinessException {
        Integer remaing = this.singleLotteryService.findRemaingForupdate(optionId);
        if (null == remaing) {
            throw new BusinessException("\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.singleLotteryService.subMainAppItemRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u53d8\u66f4\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        SingleLotteryStockManualChangeDO singleStockChange = new SingleLotteryStockManualChangeDO(true);
        singleStockChange.setRelationId(optionId);
        singleStockChange.setRelationType("app");
        singleStockChange.setBeforeStock(Long.valueOf(remaing.intValue()));
        singleStockChange.setAfterStock(Long.valueOf(remaing - quantity));
        singleStockChange.setChangeKind("sub");
        singleStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        singleStockChange.setOptionType("main");
        this.singleLotteryStockManualChangeService.insert(singleStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public void updateMainAppItemRemainingByEdit(Long appSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException {
        if (preRemaining == null || requiredRemaining == null) {
            throw new BusinessException("\u5956\u54c1\u6570\u91cf\u4fee\u6539\u5f02\u5e38\uff01");
        }
        int differRemaining = requiredRemaining - preRemaining;
        if (differRemaining == 0) {
            return;
        }
        if (differRemaining > 0) {
            this.addSingleLotteryMainStockQuantity(appSingleLotteryId, Math.abs(differRemaining));
        }
        if (differRemaining < 0) {
            this.reduceSingleLotteryMainStockQuantity(appSingleLotteryId, Math.abs(differRemaining));
        }
    }

    @Override
    @Transactional(value="credits")
    public boolean addSingleLotteryMainStockQuantity_duiba(Long optionId, Integer quantity) throws BusinessException {
        DuibaSingleLotteryDO single = this.duibaSingleLotteryService.findForupdate(optionId);
        if (null == single) {
            throw new BusinessException("\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.duibaSingleLotteryService.addMainItemRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u6dfb\u52a0\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        SingleLotteryStockManualChangeDO singleStockChange = new SingleLotteryStockManualChangeDO(true);
        singleStockChange.setRelationId(optionId);
        singleStockChange.setRelationType("duiba");
        singleStockChange.setBeforeStock(Long.valueOf(single.getMainItemRemaining().intValue()));
        singleStockChange.setAfterStock(Long.valueOf(single.getMainItemRemaining() + quantity));
        singleStockChange.setChangeKind("add");
        singleStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        singleStockChange.setOptionType("main");
        this.singleLotteryStockManualChangeService.insert(singleStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean reduceSingleLotteryMainStockQuantity_duiba(Long optionId, Integer quantity) throws BusinessException {
        DuibaSingleLotteryDO single = this.duibaSingleLotteryService.findForupdate(optionId);
        if (null == single) {
            throw new BusinessException("\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.duibaSingleLotteryService.subMainItemRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u51cf\u5c11\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        SingleLotteryStockManualChangeDO singleStockChange = new SingleLotteryStockManualChangeDO(true);
        singleStockChange.setRelationId(optionId);
        singleStockChange.setRelationType("duiba");
        singleStockChange.setBeforeStock(Long.valueOf(single.getMainItemRemaining().intValue()));
        singleStockChange.setAfterStock(Long.valueOf(single.getMainItemRemaining() - quantity));
        singleStockChange.setChangeKind("sub");
        singleStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        singleStockChange.setOptionType("main");
        this.singleLotteryStockManualChangeService.insert(singleStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean addSingleLotteryInciteStockQuantity(Long optionId, Integer quantity) throws BusinessException {
        DuibaSingleLotteryDO single = this.duibaSingleLotteryService.findForupdate(optionId);
        if (null == single) {
            throw new BusinessException("\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.duibaSingleLotteryService.addInciteItemRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u6dfb\u52a0\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        SingleLotteryStockManualChangeDO singleStockChange = new SingleLotteryStockManualChangeDO(true);
        singleStockChange.setRelationId(optionId);
        singleStockChange.setRelationType("duiba");
        singleStockChange.setBeforeStock(Long.valueOf(single.getInciteItemRemaining() == null ? 0L : (long)single.getInciteItemRemaining().intValue()));
        singleStockChange.setAfterStock(Long.valueOf(single.getInciteItemRemaining() == null ? (long)quantity.intValue() : (long)(single.getInciteItemRemaining() + quantity)));
        singleStockChange.setChangeKind("add");
        singleStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        singleStockChange.setOptionType("incite");
        this.singleLotteryStockManualChangeService.insert(singleStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public boolean reduceSingleLotteryInciteStockQuantity(Long optionId, Integer quantity) throws BusinessException {
        DuibaSingleLotteryDO single = this.duibaSingleLotteryService.findForupdate(optionId);
        if (null == single) {
            throw new BusinessException("\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u4e0d\u5b58\u5728");
        }
        int result = this.duibaSingleLotteryService.subInciteItemRemainingById(optionId, quantity);
        if (result < 1) {
            throw new BusinessException("\u51cf\u5c11\u5355\u54c1\u62bd\u5956\u5956\u9879\u5e93\u5b58\u5931\u8d25");
        }
        SingleLotteryStockManualChangeDO singleStockChange = new SingleLotteryStockManualChangeDO(true);
        singleStockChange.setRelationId(optionId);
        singleStockChange.setRelationType("duiba");
        singleStockChange.setBeforeStock(Long.valueOf(single.getInciteItemRemaining().intValue()));
        singleStockChange.setAfterStock(Long.valueOf(single.getInciteItemRemaining() - quantity));
        singleStockChange.setChangeKind("sub");
        singleStockChange.setChangeQuantity(Long.valueOf(quantity.intValue()));
        singleStockChange.setOptionType("incite");
        this.singleLotteryStockManualChangeService.insert(singleStockChange);
        return true;
    }

    @Override
    @Transactional(value="credits")
    public void updateMainItemRemainingByEdit(Long duibaSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException {
        int differRemaining;
        if (requiredRemaining == null) {
            throw new BusinessException("\u4e3b\u5956\u9879\u6570\u91cf\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u7a7a\uff01");
        }
        if (preRemaining == null) {
            preRemaining = 0;
        }
        if ((differRemaining = requiredRemaining - preRemaining) == 0) {
            return;
        }
        if (differRemaining > 0) {
            this.addSingleLotteryMainStockQuantity_duiba(duibaSingleLotteryId, Math.abs(differRemaining));
        }
        if (differRemaining < 0) {
            this.reduceSingleLotteryMainStockQuantity_duiba(duibaSingleLotteryId, Math.abs(differRemaining));
        }
    }

    @Override
    @Transactional(value="credits")
    public void updateInciteItemRemainingByEdit(Long duibaSingleLotteryId, Integer preRemaining, Integer requiredRemaining) throws BusinessException {
        int differRemaining;
        if (requiredRemaining == null) {
            throw new BusinessException("\u9f13\u52b1\u5956\u5956\u9879\u6570\u91cf\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u7a7a\uff01");
        }
        if (preRemaining == null) {
            preRemaining = 0;
        }
        if ((differRemaining = requiredRemaining - preRemaining) == 0) {
            return;
        }
        if (differRemaining > 0) {
            this.addSingleLotteryInciteStockQuantity(duibaSingleLotteryId, Math.abs(differRemaining));
        }
        if (differRemaining < 0) {
            this.reduceSingleLotteryInciteStockQuantity(duibaSingleLotteryId, Math.abs(differRemaining));
        }
    }
}

