/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppSingleLotteryDO;
import cn.com.duiba.service.domain.dataobject.SingleLotteryStockConsumeDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.SingleLotteryStockConsumeBo;
import cn.com.duiba.service.item.domain.dataobject.DuibaSingleLotteryDO;
import cn.com.duiba.service.item.domain.dataobject.SingleLotteryAppSpecifyDO;
import cn.com.duiba.service.item.service.DuibaSingleLotteryService;
import cn.com.duiba.service.service.SingleLotteryService;
import cn.com.duiba.service.service.SingleLotteryStockConsumeService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SingleLotteryStockConsumeBoImpl
implements SingleLotteryStockConsumeBo {
    private static Logger log = LoggerFactory.getLogger(SingleLotteryStockConsumeBoImpl.class);
    @Autowired
    private DuibaSingleLotteryService duibaSingleLotteryService;
    @Autowired
    private SingleLotteryStockConsumeService singleLotteryStockConsumeService;
    @Autowired
    private SingleLotteryService singleLotteryService;

    @Override
    @Transactional(value="credits")
    public void consumeDuibaSingleLotteryStock(Long duibaSingleLotteryId, Long appId, Integer optionType, String bizId, String bizSource) throws BusinessException {
        int ret;
        String optionTypeStr = null;
        DuibaSingleLotteryDO duibaSingle = this.duibaSingleLotteryService.findForupdate(duibaSingleLotteryId);
        if (null == duibaSingle) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5355\u54c1\u62bd\u5956");
        }
        if (optionType == 1) {
            if (duibaSingle.getMainItemRemaining() <= 0) {
                throw new BusinessException("\u5927\u5956\u5e93\u5b58\u4e0d\u8db3");
            }
            ret = this.duibaSingleLotteryService.reduceMainItemRemaining(duibaSingle.getId());
            if (ret < 1) {
                throw new BusinessException("\u62bd\u5956\u5931\u8d25\uff0c\u66f4\u65b0\u5927\u5956\u5269\u4f59\u6570\u91cf\u5f02\u5e38");
            }
            optionTypeStr = "main";
        } else if (optionType == 2) {
            if (duibaSingle.getInciteItemRemaining() <= 0) {
                throw new BusinessException("\u5c0f\u5956\u5e93\u5b58\u4e0d\u8db3");
            }
            ret = this.duibaSingleLotteryService.reduceInciteItemRemaining(duibaSingle.getId());
            if (ret < 1) {
                throw new BusinessException("\u62bd\u5956\u5931\u8d25\uff0c\u66f4\u65b0\u5c0f\u5956\u5269\u4f59\u6570\u91cf\u5f02\u5e38");
            }
            optionTypeStr = "incite";
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDO consume = new SingleLotteryStockConsumeDO(true);
        consume.setRelationId(duibaSingle.getId());
        consume.setRelationType("duiba");
        consume.setAppId(appId);
        consume.setAction("pay");
        consume.setBizId(bizId);
        consume.setOptionType(optionTypeStr);
        consume.setBizSource(bizSource);
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(consume);
    }

    @Override
    @Transactional(value="credits")
    public void paybackDuibaSingleLotteryStock(String bizId, String bizSource) throws BusinessException {
        int ret;
        SingleLotteryStockConsumeDO consume = this.singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        DuibaSingleLotteryDO duibaSingle = this.duibaSingleLotteryService.findForupdate(consume.getRelationId());
        if (null == duibaSingle) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        if (consume.getOptionType().equals("main")) {
            ret = this.duibaSingleLotteryService.addMainItemRemaining(duibaSingle.getId());
            if (ret < 1) {
                throw new BusinessException("\u8fd4\u5927\u5956\u5269\u4f59\u6570\u91cf\u5f02\u5e38");
            }
        } else if (consume.getOptionType().equals("incite") && (ret = this.duibaSingleLotteryService.addInciteItemRemaining(duibaSingle.getId())) < 1) {
            throw new BusinessException("\u8fd4\u5c0f\u5956\u5269\u4f59\u6570\u91cf\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDO detail = new SingleLotteryStockConsumeDO(true);
        detail.setRelationId(consume.getRelationId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(consume.getAppId());
        detail.setAction("back");
        detail.setBizId(consume.getBizId());
        detail.setBizSource(consume.getBizSource());
        detail.setOptionType(consume.getOptionType());
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(detail);
    }

    @Override
    @Transactional(value="credits")
    public void consumeSingleLotterySpecifyStock(Long duibaSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException {
        SingleLotteryAppSpecifyDO specify = this.duibaSingleLotteryService.findSpecifyByDuibaSingleLotteryAndApp(duibaSingleLotteryId, appId);
        if (null == specify) {
            throw new BusinessException("\u65e0\u5b9a\u5411\u5173\u7cfb");
        }
        if ((specify = this.duibaSingleLotteryService.findSpecifyForupdate(specify.getId())).getRemaining() <= 0) {
            throw new BusinessException("\u5355\u54c1\u5b9a\u5411\u5e93\u5b58\u4e0d\u8db3");
        }
        int ret = this.duibaSingleLotteryService.reduceSpecifyAppRemaining(duibaSingleLotteryId, appId);
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5355\u54c1\u62bd\u5956\u5b9a\u5411\u5206\u914d\u6570\u91cf\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDO consume = new SingleLotteryStockConsumeDO(true);
        consume.setRelationId(specify.getId());
        consume.setRelationType("specify");
        consume.setAppId(appId);
        consume.setAction("pay");
        consume.setBizId(bizId);
        consume.setOptionType("main");
        consume.setBizSource(bizSource);
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(consume);
    }

    @Override
    @Transactional(value="credits")
    public void paybackSingleLotterySpecifyStock(String bizId, String bizSource) throws BusinessException {
        SingleLotteryStockConsumeDO consume = this.singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            log.error("\u65e0\u6d88\u8d39\u8bb0\u5f55");
            return;
        }
        SingleLotteryAppSpecifyDO specify = this.duibaSingleLotteryService.findSpecifyForupdate(consume.getRelationId());
        if (null == specify) {
            log.error("\u65e0\u5b9a\u5411\u8bb0\u5f55");
            return;
        }
        int ret = this.duibaSingleLotteryService.addSpecifyAppRemaining(specify.getDuibaSingleLotteryId(), specify.getAppId());
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5355\u54c1\u62bd\u5956\u5b9a\u5411\u5206\u914d\u6570\u91cf\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDO detail = new SingleLotteryStockConsumeDO(true);
        detail.setRelationId(specify.getId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(specify.getAppId());
        detail.setAction("back");
        detail.setBizId(bizId);
        detail.setOptionType(consume.getOptionType());
        detail.setBizSource(consume.getBizSource());
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(detail);
    }

    @Override
    @Transactional(value="credits")
    public void consumeDevSingleLotteryStock(Long appSingleLotteryId, Long appId, String bizId, String bizSource) throws BusinessException {
        AppSingleLotteryDO appSingle = this.singleLotteryService.findForupdate(appSingleLotteryId);
        if (null == appSingle) {
            throw new BusinessException("\u4e0d\u5b58\u5728\u7684\u5355\u54c1\u62bd\u5956");
        }
        if (appSingle.getMainAppItemRemaining() <= 0) {
            throw new BusinessException("\u5e93\u5b58\u4e0d\u8db3");
        }
        int ret = this.singleLotteryService.reduceMainAppItemRemaining(appSingle.getId());
        if (ret < 1) {
            throw new BusinessException("\u62bd\u5956\u5931\u8d25\uff0c\u66f4\u65b0\u5c0f\u5956\u5269\u4f59\u6570\u91cf\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDO consume = new SingleLotteryStockConsumeDO(true);
        consume.setRelationId(appSingle.getId());
        consume.setRelationType("app");
        consume.setAppId(appId);
        consume.setAction("pay");
        consume.setBizId(bizId);
        consume.setOptionType("main");
        consume.setBizSource(bizSource);
        consume.setQuantity(Long.valueOf(1L));
        consume.setGmtCreate(now);
        consume.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(consume);
    }

    @Override
    @Transactional(value="credits")
    public void pabackDevSingleLoteryStock(String bizId, String bizSource) throws BusinessException {
        SingleLotteryStockConsumeDO consume = this.singleLotteryStockConsumeService.findByBizIdAndSource(bizId, bizSource);
        if (null == consume) {
            log.error("\u65e0\u6d88\u8d39\u8bb0\u5f55");
            return;
        }
        AppSingleLotteryDO appSingle = this.singleLotteryService.findForupdate(consume.getRelationId());
        if (null == appSingle) {
            log.error("\u65e0\u8bb0\u5f55");
            return;
        }
        int ret = this.singleLotteryService.addMainAppItemRemaining(appSingle.getId());
        if (ret < 1) {
            throw new BusinessException("\u62bd\u5956\u5931\u8d25\uff0c\u66f4\u65b0\u5c0f\u5956\u5269\u4f59\u6570\u91cf\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        SingleLotteryStockConsumeDO detail = new SingleLotteryStockConsumeDO(true);
        detail.setRelationId(consume.getRelationId());
        detail.setRelationType(consume.getRelationType());
        detail.setAppId(consume.getAppId());
        detail.setAction("back");
        detail.setBizId(consume.getBizId());
        detail.setOptionType(consume.getOptionType());
        detail.setBizSource(consume.getBizSource());
        detail.setQuantity(Long.valueOf(1L));
        detail.setGmtCreate(now);
        detail.setGmtModified(now);
        this.singleLotteryStockConsumeService.insert(detail);
    }
}

