/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.TurntableStockConsumeDO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.item.bo.TurntableStockConsumeBo;
import cn.com.duiba.service.item.domain.dataobject.TurntableOptionsDO;
import cn.com.duiba.service.item.service.DuibaTurntableService;
import cn.com.duiba.service.service.TurntableOptionsService;
import cn.com.duiba.service.service.TurntableStockConsumeService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TurntableStockConsumeBoImpl
implements TurntableStockConsumeBo {
    private static final Logger log = LoggerFactory.getLogger(TurntableStockConsumeBoImpl.class);
    @Autowired
    private DuibaTurntableService duibaTurntableService;
    @Autowired
    private TurntableStockConsumeService turntableStockConsumeService;
    @Autowired
    private TurntableOptionsService turntableOptionsService;

    @Override
    @Transactional(value="credits")
    public void consumeDuibaTurntableOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws BusinessException {
        TurntableOptionsDO option = this.duibaTurntableService.findOptionByIdForupdate(optionId);
        if (null == option) {
            throw new BusinessException("\u5956\u9879\u4e0d\u5b58\u5728");
        }
        if (option.getRemaining() != null && option.getRemaining() <= 0) {
            throw new BusinessException("\u5956\u9879\u5e93\u5b58\u4e0d\u8db3");
        }
        int ret = this.duibaTurntableService.decrementOptionRemaining(option.getId());
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5151\u5427\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        TurntableStockConsumeDO turntableStock = new TurntableStockConsumeDO(true);
        turntableStock.setRelationId(option.getId());
        turntableStock.setRelationType("duiba");
        turntableStock.setAppId(appId);
        turntableStock.setAction("pay");
        turntableStock.setBizId(bizId);
        turntableStock.setBizSource(bizSource);
        turntableStock.setQuantity(Long.valueOf(1L));
        turntableStock.setGmtCreate(now);
        turntableStock.setGmtModified(now);
        this.turntableStockConsumeService.insert(turntableStock);
    }

    @Override
    @Transactional(value="credits")
    public void paybackDuibaTurntableOptionStock(String bizId, String bizSource) throws BusinessException {
        TurntableStockConsumeDO consume = this.turntableStockConsumeService.findByBizIdAndSourcePay(bizId, bizSource);
        if (null == consume) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        TurntableOptionsDO option = this.duibaTurntableService.findOptionByIdForupdate(consume.getRelationId());
        if (null == option) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        int ret = this.duibaTurntableService.incrementOptionRemaining(option.getId());
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5151\u5427\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        TurntableStockConsumeDO turntableStock = new TurntableStockConsumeDO(true);
        turntableStock.setRelationId(consume.getRelationId());
        turntableStock.setRelationType(consume.getRelationType());
        turntableStock.setAppId(consume.getAppId());
        turntableStock.setAction("back");
        turntableStock.setBizId(consume.getBizId());
        turntableStock.setBizSource(consume.getBizSource());
        turntableStock.setQuantity(consume.getQuantity());
        turntableStock.setGmtCreate(now);
        turntableStock.setGmtModified(now);
        this.turntableStockConsumeService.insert(turntableStock);
    }

    @Override
    @Transactional(value="credits")
    public void consumeAppTurntableOptionStock(Long optionId, Long appId, String bizId, String bizSource) throws BusinessException {
        TurntableOptionsDO option = this.turntableOptionsService.findForupdate(optionId);
        if (null == option) {
            throw new BusinessException("\u5956\u9879\u4e0d\u5b58\u5728");
        }
        if (option.getRemaining() != null && option.getRemaining() <= 0) {
            throw new BusinessException("\u5956\u9879\u5e93\u5b58\u4e0d\u8db3");
        }
        int ret = this.turntableOptionsService.reduceRemaining(optionId);
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5f00\u53d1\u8005\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        TurntableStockConsumeDO turntableStock = new TurntableStockConsumeDO(true);
        turntableStock.setRelationId(option.getId());
        turntableStock.setRelationType("app");
        turntableStock.setAppId(appId);
        turntableStock.setAction("pay");
        turntableStock.setBizId(bizId);
        turntableStock.setBizSource(bizSource);
        turntableStock.setQuantity(Long.valueOf(1L));
        turntableStock.setGmtCreate(now);
        turntableStock.setGmtModified(now);
        this.turntableStockConsumeService.insert(turntableStock);
    }

    @Override
    @Transactional(value="credits")
    public void paybackAppTurntableOptionStock(String bizId, String bizSource) throws BusinessException {
        TurntableStockConsumeDO consume = this.turntableStockConsumeService.findByBizIdAndSourcePay(bizId, bizSource);
        if (null == consume) {
            log.error("\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return;
        }
        TurntableOptionsDO option = this.turntableOptionsService.findForupdate(consume.getRelationId());
        if (null == option) {
            throw new BusinessException("\u5956\u9879\u4e0d\u5b58\u5728");
        }
        int ret = this.turntableOptionsService.addRemaining(option.getId());
        if (ret < 1) {
            throw new BusinessException("\u66f4\u65b0\u5f00\u53d1\u8005\u6d3b\u52a8\u5956\u9879\u5269\u4f59\u4e2a\u6570\u5f02\u5e38");
        }
        Date now = new Date(System.currentTimeMillis() / 1000L * 1000L);
        TurntableStockConsumeDO turntableStock = new TurntableStockConsumeDO(true);
        turntableStock.setRelationId(consume.getRelationId());
        turntableStock.setRelationType(consume.getRelationType());
        turntableStock.setAppId(consume.getAppId());
        turntableStock.setAction("back");
        turntableStock.setBizId(consume.getBizId());
        turntableStock.setBizSource(consume.getBizSource());
        turntableStock.setQuantity(Long.valueOf(1L));
        turntableStock.setGmtCreate(now);
        turntableStock.setGmtModified(now);
        this.turntableStockConsumeService.insert(turntableStock);
    }
}

