/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.dao.impl;

import cn.com.duiba.service.dao.BaseDao;
import cn.com.duiba.service.dao.DatabaseSchema;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.vo.CouponCountVO;
import cn.com.duiba.service.item.dao.CouponDao;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class CouponDaoImpl
extends BaseDao
implements CouponDao {
    @Override
    public void insert(CouponDO couponDO) {
        this.insert("insert", couponDO);
    }

    @Override
    public int update(CouponDO couponDO) {
        return this.insert("update", couponDO);
    }

    @Override
    public CouponDO find(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return (CouponDO)this.selectOne("find", paramMap);
    }

    @Override
    public void releaseCouponById(Long couponId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("couponId", couponId);
        this.update("releaseCouponById", paramMap);
    }

    @Override
    public void batchInsertCoupon(List<CouponDO> ls) {
        HashMap<String, List<CouponDO>> paramMap = new HashMap<String, List<CouponDO>>();
        paramMap.put("list", ls);
        this.insert("batchInsertCoupon", paramMap);
    }

    @Override
    public Integer batchDeleteCoupon(List<Long> ls) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("list", ls);
        return this.delete("batchDeleteCoupon", paramMap);
    }

    @Override
    public Integer deleteOneCoupon(Long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.delete("deleteOneCoupon", paramMap);
    }

    @Override
    public Integer deleteCouponByBatch(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return this.delete("deleteCouponByBatch", paramMap);
    }

    @Override
    public Integer ishavingCoupon(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return (Integer)this.selectOne("ishavingCoupon", paramMap);
    }

    @Override
    public CouponDO getOneCouponByBatchForUpdate(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return (CouponDO)this.selectOne("getOneCouponByBatchForUpdate", paramMap);
    }

    @Override
    public CouponDO findOneByBatch(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return (CouponDO)this.selectOne("findOneByBatch", paramMap);
    }

    @Override
    public CouponDO findByBatchAndCode(Long batchId, String code) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("batchId", batchId);
        paramMap.put("code", code);
        return (CouponDO)this.selectOne("findByBatchAndCode", paramMap);
    }

    @Override
    public List<CouponDO> findNoUsedByBatch(Long batchId, Integer max) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("batchId", batchId);
        paramMap.put("max", max);
        return this.selectList("findNoUsedByBatch", paramMap);
    }

    @Override
    public List<CouponDO> searchCoupon(Long appItemId, Long itemId, String code, Long batchId, String used, Integer start, Integer pageSize) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("appItemId", appItemId);
        paramMap.put("itemId", itemId);
        paramMap.put("code", code);
        paramMap.put("batchId", batchId);
        paramMap.put("used", used);
        paramMap.put("start", start);
        paramMap.put("pageSize", pageSize);
        return this.selectList("searchCoupon", paramMap);
    }

    @Override
    public Integer countCoupon(Long appItemId, Long itemId, Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        paramMap.put("itemId", itemId);
        paramMap.put("batchId", batchId);
        return (Integer)this.selectOne("countCoupon", paramMap);
    }

    @Override
    public Integer countUsedCoupon(Long appItemId, Long itemId, Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("appItemId", appItemId);
        paramMap.put("itemId", itemId);
        paramMap.put("batchId", batchId);
        return (Integer)this.selectOne("countUsedCoupon", paramMap);
    }

    @Override
    public Integer countByItemId(Long itemId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("itemId", itemId);
        return (Integer)this.selectOne("countByItemId", paramMap);
    }

    @Override
    public List<CouponDO> findCouponList(List<Long> list) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("list", list);
        return this.selectList("findCouponList", paramMap);
    }

    @Override
    public Integer countByCouponBatch(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return (Integer)this.selectOne("countByCouponBatch", paramMap);
    }

    @Override
    public List<CouponDO> findCouponByLimit(Map<String, Object> params) {
        return this.selectList("findCouponByLimit", params);
    }

    @Override
    public Long findCouponByCount(Map<String, Object> params) {
        return (Long)this.selectOne("findCouponByCount", params);
    }

    @Override
    public List<CouponCountVO> countByItemIds(List<Long> itemIds) {
        HashMap<String, List<Long>> paramMap = new HashMap<String, List<Long>>();
        paramMap.put("itemIds", itemIds);
        return this.selectList("countByItemIds", paramMap);
    }

    @Override
    public List<CouponDO> findCouponByBatchAndTotal(Map<String, Object> map) {
        return this.selectList("findCouponByBatchAndTotal", map);
    }

    @Override
    public int lockCoupon(long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.update("lockCoupon", paramMap);
    }

    @Override
    public int unlockCoupon(long id) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("id", id);
        return this.update("unlockCoupon", paramMap);
    }

    @Override
    public int deleteByBatchId(long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return this.delete("deleteByBatchId", paramMap);
    }

    @Override
    public List<String> findAllCodeByBatchId(long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return this.selectList("findAllCodeByBatchId", paramMap);
    }

    @Override
    public Integer noLockCountByBatchId(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return (Integer)this.selectOne("noLockCountByBatchId", paramMap);
    }

    @Override
    public CouponDO findOneCouponByBatchId(Long batchId) {
        HashMap<String, Long> paramMap = new HashMap<String, Long>();
        paramMap.put("batchId", batchId);
        return (CouponDO)this.selectOne("findOneCouponByBatchId", paramMap);
    }

    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}

