/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.service.domain.dataobject.AppPermissionDO;
import cn.com.duiba.service.domain.dataobject.AppShowcaseContentDO;
import cn.com.duiba.service.domain.dataobject.PermissionDO;
import cn.com.duiba.service.domain.vo.ItemKey;
import cn.com.duiba.service.domain.vo.ShowcasePreviewVO;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.service.exception.StatusException;
import cn.com.duiba.service.item.bo.AppShowcaseContentBo;
import cn.com.duiba.service.item.service.AppPermissionService;
import cn.com.duiba.service.item.service.ItemKeyService;
import cn.com.duiba.service.item.service.PermissionService;
import cn.com.duiba.service.service.AppService;
import cn.com.duiba.service.service.AppShowcaseContentService;
import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppShowcaseContentBoImpl
implements AppShowcaseContentBo {
    @Resource
    private AppShowcaseContentService appShowcaseContentService;
    @Resource
    private AppService appService;
    @Resource
    private ItemKeyService itemKeyService;
    @Resource
    private AppPermissionService appPermissionService;
    @Resource
    private PermissionService permissionService;

    @Override
    public void clearShowcase() {
        List appIds = this.appService.findAllEnable();
        Date now = new Date();
        Date nowBefore7 = DateUtils.daysAddOrSub((Date)now, (int)-7);
        for (Long it : appIds) {
            AppShowcaseContentDO earlyShowcase3;
            AppShowcaseContentDO earlyShowcase2;
            AppShowcaseContentDO earlyShowcase1 = this.appShowcaseContentService.findEarlyLastAvailableShowcase(it, Integer.valueOf(1));
            if (earlyShowcase1 != null && earlyShowcase1.getStartTime().after(nowBefore7)) {
                this.appShowcaseContentService.updateDeletedByAppIdAndStartTimeAndPlace(it, nowBefore7, 1);
            }
            if ((earlyShowcase2 = this.appShowcaseContentService.findEarlyLastAvailableShowcase(it, Integer.valueOf(2))) != null && earlyShowcase2.getStartTime().after(nowBefore7)) {
                this.appShowcaseContentService.updateDeletedByAppIdAndStartTimeAndPlace(it, nowBefore7, 2);
            }
            if ((earlyShowcase3 = this.appShowcaseContentService.findEarlyLastAvailableShowcase(it, Integer.valueOf(3))) == null || !earlyShowcase3.getStartTime().after(nowBefore7)) continue;
            this.appShowcaseContentService.updateDeletedByAppIdAndStartTimeAndPlace(it, nowBefore7, 3);
        }
    }

    @Override
    public Map<String, Object> getShowcases4Dev(Long appId, int place) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List laters = this.appShowcaseContentService.findLaterAvailableShowcases(appId, Integer.valueOf(place));
        AppShowcaseContentDO early = this.appShowcaseContentService.findEarlyLastAvailableShowcase(appId, Integer.valueOf(place));
        ShowcasePreviewVO firstPreVO = null;
        AppShowcaseContentDO firstPre = null;
        if (early != null) {
            firstPre = early;
        } else if (laters != null && !laters.isEmpty()) {
            firstPre = (AppShowcaseContentDO)laters.get(0);
        }
        if (firstPre != null) {
            ItemKey itemKey = null;
            if ("item".equals(firstPre.getRelationType())) {
                itemKey = this.itemKeyService.getItemKey(firstPre.getRelationId(), null, firstPre.getAppId());
            }
            if ("appItem".equals(firstPre.getRelationType())) {
                itemKey = this.itemKeyService.getItemKey(null, firstPre.getRelationId(), firstPre.getAppId());
            }
            firstPreVO = new ShowcasePreviewVO(firstPre);
            firstPreVO.setNeedTime(Boolean.valueOf(this.isNeedTime(itemKey)));
        }
        resultMap.put("early", early);
        resultMap.put("laters", laters);
        resultMap.put("firstPre", firstPreVO);
        return resultMap;
    }

    @Override
    public ShowcasePreviewVO getPreviewVO(Long appShowcaseContentId) {
        AppShowcaseContentDO pre = this.appShowcaseContentService.find(appShowcaseContentId);
        ItemKey itemKey = null;
        if ("item".equals(pre.getRelationType())) {
            itemKey = this.itemKeyService.getItemKey(pre.getRelationId(), null, pre.getAppId());
        }
        if ("appItem".equals(pre.getRelationType())) {
            itemKey = this.itemKeyService.getItemKey(null, pre.getRelationId(), pre.getAppId());
        }
        ShowcasePreviewVO vo = new ShowcasePreviewVO(pre);
        vo.setNeedTime(Boolean.valueOf(this.isNeedTime(itemKey)));
        return vo;
    }

    private boolean isNeedTime(ItemKey itemKey) {
        if (itemKey == null) {
            return false;
        }
        boolean ifTimeLimit = itemKey.getItem() != null && itemKey.getItem().isOpTypeItem(0) || itemKey.getAppItem() != null && itemKey.getAppItem().isOpTypeAppItem(0);
        boolean ifInDateLimit = false;
        try {
            ifInDateLimit = !this.limitDayIsStart(itemKey) && !this.limitDayIsOver(itemKey);
        }
        catch (Exception e) {
            ifInDateLimit = false;
        }
        return ifTimeLimit && ifInDateLimit;
    }

    private boolean limitDayIsStart(ItemKey itemKey) throws StatusException {
        String limitDate = null;
        if (itemKey.isItemMode()) {
            limitDate = itemKey.getItem().getLimitDate();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().getLimitDate() != null && !itemKey.getItem().getLimitDate().equals("no")) {
                limitDate = itemKey.getItem().getLimitDate();
            } else if (itemKey.getAppItem().getLimitDate() != null) {
                limitDate = itemKey.getAppItem().getLimitDate();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            limitDate = itemKey.getAppItem().getLimitDate();
        }
        if (StringUtils.isNotBlank((String)limitDate) && !limitDate.equals("no")) {
            String startDay = limitDate.split(",")[0];
            Date start = DateUtils.getDayDate((String)startDay);
            if (System.currentTimeMillis() < start.getTime()) {
                return true;
            }
        }
        return false;
    }

    private boolean limitDayIsOver(ItemKey itemKey) throws StatusException {
        String limitDate = null;
        if (itemKey.isItemMode()) {
            limitDate = itemKey.getItem().getLimitDate();
        }
        if (itemKey.isDuibaAppItemMode()) {
            if (itemKey.getItem().getLimitDate() != null && !itemKey.getItem().getLimitDate().equals("no")) {
                limitDate = itemKey.getItem().getLimitDate();
            } else if (itemKey.getAppItem().getLimitDate() != null) {
                limitDate = itemKey.getAppItem().getLimitDate();
            }
        } else if (itemKey.isSelfAppItemMode()) {
            limitDate = itemKey.getAppItem().getLimitDate();
        }
        if (StringUtils.isNotBlank((String)limitDate) && !limitDate.equals("no")) {
            String endDay = limitDate.split(",")[1];
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.getDayDate((String)endDay));
            cal.add(5, 1);
            Date end = cal.getTime();
            if (System.currentTimeMillis() > end.getTime()) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional(value="credits")
    public void deleteAppShowcaseContent(Long id) throws BusinessException {
        AppShowcaseContentDO showcase = this.appShowcaseContentService.find(id);
        if (showcase == null || showcase.getDeleted().booleanValue()) {
            throw new BusinessException("\u6a71\u7a97\u5185\u5bb9\u4e3a\u7a7a");
        }
        if ("item".equals(showcase.getRelationType())) {
            this.revokeAppPermission(showcase.getRelationId(), showcase.getAppId());
        }
        this.appShowcaseContentService.updateDeletedById(id);
    }

    private void revokeAppPermission(Long itemId, Long appId) {
        PermissionDO permission = this.permissionService.find4DuibaShowcase(String.valueOf(itemId));
        if (permission == null || permission.getDeleted().booleanValue()) {
            return;
        }
        AppPermissionDO appPermission = this.appPermissionService.find4DuibaShowcaseEnable(appId, permission.getId());
        if (appPermission == null) {
            return;
        }
        this.appPermissionService.disable4CancelDuibaShowcase(appPermission.getId());
    }
}

