/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.item.dao.AppItemMaskDao;
import cn.com.duiba.service.item.domain.dataobject.AppItemMaskingDO;
import cn.com.duiba.service.item.service.AppItemMaskService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppItemMaskServiceImpl
implements AppItemMaskService {
    @Resource
    private AppItemMaskDao appItemMaskDao;
    @Resource
    private CacheClient cacheClient;

    private String getItemIdCacheOfAppItemMaskByAppId(Long appId) {
        return "item.itemIdCacheOfAppItemMaskByAppId_" + appId;
    }

    @Override
    public void delete(Long id) {
        AppItemMaskingDO d = this.appItemMaskDao.find(id);
        if (d != null) {
            this.appItemMaskDao.delete(id);
            this.cacheClient.remove(this.getItemIdCacheOfAppItemMaskByAppId(d.getAppId()));
        }
    }

    @Override
    public List<AppItemMaskingDO> findAllByApp(Long appId) {
        return this.appItemMaskDao.findAllByApp(appId);
    }

    @Override
    public AppItemMaskingDO findByAppIdAndItemId(Long appId, Long itemId) {
        return this.appItemMaskDao.findByAppIdAndItemId(appId, itemId);
    }

    @Override
    public void insert(AppItemMaskingDO appItemMaskingDO) {
        this.appItemMaskDao.insert(appItemMaskingDO);
        this.cacheClient.remove(this.getItemIdCacheOfAppItemMaskByAppId(appItemMaskingDO.getAppId()));
    }

    @Override
    public List<Long> findItemAppMasking(Long appId) {
        String key = this.getItemIdCacheOfAppItemMaskByAppId(appId);
        List<Long> itemIds = (List<Long>)this.cacheClient.get(key);
        if (itemIds == null) {
            itemIds = this.appItemMaskDao.findItemAppMasking(appId);
            this.cacheClient.set(key, itemIds, 300);
        }
        return itemIds;
    }
}

