/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.bo.impl;

import cn.com.duiba.dcommons.enums.GoodsTypeEnum;
import cn.com.duiba.service.domain.dataobject.CouponDO;
import cn.com.duiba.service.domain.dataobject.ItemDO;
import cn.com.duiba.service.domain.dataobject.TbGoodsOpenUrlDO;
import cn.com.duiba.service.domain.dto.SellerDto;
import cn.com.duiba.service.item.bo.ImmediatelyButtonBackendBo;
import cn.com.duiba.service.item.service.CouponService;
import cn.com.duiba.service.item.service.ItemService;
import cn.com.duiba.service.item.service.SellerSevice;
import cn.com.duiba.service.item.service.TbGoodsOpenurlService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.SecurityUtils;
import cn.com.duiba.wolf.utils.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImmediatelyButtonBackendBoImpl
implements ImmediatelyButtonBackendBo {
    @Autowired
    private ItemService itemService;
    @Autowired
    private SellerSevice sellerSevice;
    @Autowired
    private CouponService couponService;
    @Resource
    private TbGoodsOpenurlService tbGoodsOpenurlService;

    @Override
    public DubboResult<String> selectImmediatelyButtonFromItem(Long itemId, GoodsTypeEnum gtype, Long orderId, String userAgent, String hdtoolFalg, String urlParameter, String embedClickurl) {
        if (itemId == null || gtype == null || userAgent == null || hdtoolFalg == null) {
            return DubboResult.failResult((String)("\u8f93\u5165\u53c2\u6570 \u4e0d\u80fd\u4e3a\u7a7aitemId\uff1a" + itemId + " orderId:" + gtype + " userAgent:" + userAgent + " hdtoolFalg:" + hdtoolFalg));
        }
        userAgent = userAgent.toLowerCase();
        String returls = "";
        TbGoodsOpenUrlDO goodOpenUrl = this.tbGoodsOpenurlService.findTbGoodsOpenurl(itemId, gtype.getGtype());
        if (goodOpenUrl != null) {
            returls = "2".equals(hdtoolFalg) || goodOpenUrl.getImmediatelyButton() == 1 ? (!"2".equals(hdtoolFalg) ? "/crecord/recordDetailNew/" + orderId + "?after=1" : (userAgent.contains("android") ? goodOpenUrl.getAndroidDownload() : goodOpenUrl.getIosDownload())) : (userAgent.contains("android") ? goodOpenUrl.getAndroidDownload() : goodOpenUrl.getIosDownload());
        } else if (gtype.getGtype() == 0) {
            ItemDO item = this.itemService.find(itemId);
            if (item == null) {
                return DubboResult.failResult((String)("\u60a8\u8f93\u5165\u7684 itemId" + itemId + " \u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684 \u4f18\u60e0\u5238\u4fe1\u606f"));
            }
            returls = userAgent.contains("android") ? item.getAndroidDownload() : (item.getIosDownload() != null ? item.getIosDownload() : item.getIosOpen());
        }
        if (returls == null || returls.length() == 0) {
            returls = "";
        } else if (urlParameter != null && urlParameter.length() > 0 && embedClickurl != null && embedClickurl.length() > 0 && !"2".equals(hdtoolFalg) && goodOpenUrl.getImmediatelyButton() != 1) {
            try {
                returls = String.valueOf(embedClickurl) + URLEncoder.encode(returls, "utf-8") + urlParameter;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return DubboResult.successResult((Object)returls);
    }

    @Override
    public DubboResult<String> selectImmediatelyButtonFromCoupon(Long couponId, Long itemId, Long orderId, String urlParameter, String embedClickurl, String hdtoolFalg) {
        if (itemId == null || orderId == null || couponId == null || hdtoolFalg == null) {
            return DubboResult.failResult((String)("\u8f93\u5165\u53c2\u6570 \u4e0d\u80fd\u4e3a\u7a7aitemId\uff1a" + itemId + " orderId:" + orderId + " couponId:" + couponId + " hdtoolFalg:" + hdtoolFalg));
        }
        String returls = "";
        ItemDO item = this.itemService.find(itemId);
        if (item == null) {
            return DubboResult.failResult((String)("\u60a8\u8f93\u5165\u7684 itemId" + itemId + " \u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684 \u4f18\u60e0\u5238\u4fe1\u606f"));
        }
        if (item.getImmediatelyButton() == 1 && "1".equals(hdtoolFalg)) {
            returls = "/crecord/recordDetailNew/" + orderId + "?after=1";
            return DubboResult.successResult((Object)returls);
        }
        CouponDO coupon = this.couponService.find(couponId);
        if (coupon == null) {
            return DubboResult.failResult((String)("\u60a8\u8f93\u5165\u7684 couponId" + itemId + " \u672a\u67e5\u627e\u5230\u5bf9\u5e94\u7684 \u4f18\u60e0\u5238\u4fe1\u606f"));
        }
        returls = coupon.getCode();
        if (item.getSellerId() != null && item.getSellerId() != 0L) {
            StringBuffer sb = new StringBuffer();
            StringBuffer urlParam = new StringBuffer();
            Map mapRequest = null;
            if (!"".equals(returls)) {
                mapRequest = UrlUtils.uRLRequest((String)returls);
                for (String strRequestKey : mapRequest.keySet()) {
                    sb.append((String)mapRequest.get(strRequestKey));
                    if (urlParam.length() == 0) {
                        urlParam.append(String.valueOf(strRequestKey) + "=" + (String)mapRequest.get(strRequestKey));
                        continue;
                    }
                    urlParam.append("&" + strRequestKey + "=" + (String)mapRequest.get(strRequestKey));
                }
            }
            if (orderId != null) {
                String timestamp = DateUtils.getMillisecond();
                sb.append(timestamp);
                sb.append(orderId);
                if (urlParam.length() == 0) {
                    urlParam.append("timestamp=" + timestamp);
                } else {
                    urlParam.append("&timestamp=" + timestamp);
                }
                urlParam.append("&orderId=" + orderId);
            }
            SellerDto result = this.sellerSevice.findById(item.getSellerId());
            returls = String.valueOf(UrlUtils.urlPage((String)returls)) + "?" + urlParam + "&sign=" + SecurityUtils.encode2StringBySHA((String)(String.valueOf(sb.toString()) + result.getSafeSign()));
        }
        if (urlParameter != null && urlParameter.length() > 0 && embedClickurl != null && embedClickurl.length() > 0) {
            try {
                returls = String.valueOf(embedClickurl) + URLEncoder.encode(returls, "utf-8") + urlParameter;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return DubboResult.successResult((Object)returls);
    }
}

