/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.CouponBatchDO;
import cn.com.duiba.service.item.dao.CouponBatchDao;
import cn.com.duiba.service.item.service.CouponBatchService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CouponBatchServiceImpl
implements CouponBatchService {
    @Resource
    private CouponBatchDao couponBatchDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "item.couponBatchById_" + id;
    }

    @Override
    public CouponBatchDO insert(CouponBatchDO couponBatchDO) {
        this.couponBatchDao.insert(couponBatchDO);
        return couponBatchDO;
    }

    @Override
    public int update(CouponBatchDO couponBatchDO) {
        int ret = this.couponBatchDao.update(couponBatchDO);
        this.cacheClient.remove(this.getCacheKeyById(couponBatchDO.getId()));
        return ret;
    }

    @Override
    public CouponBatchDO find(Long id) {
        String key = this.getCacheKeyById(id);
        CouponBatchDO d = (CouponBatchDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.couponBatchDao.find(id);
            this.cacheClient.set(key, (Object)d, 300);
        }
        return d;
    }

    @Override
    public CouponBatchDO findForUpdate(Long id) {
        return this.couponBatchDao.findForUpdate(id);
    }

    @Override
    public CouponBatchDO findItemNextBatch(Long itemId) {
        return this.couponBatchDao.findItemNextBatch(itemId);
    }

    @Override
    public CouponBatchDO findAppItemNextBatch(Long appItemId) {
        return this.couponBatchDao.findAppItemNextBatch(appItemId);
    }

    @Override
    public CouponBatchDO findItemMaxValidEndDateBatch(Long itemId) {
        return this.couponBatchDao.findItemMaxValidEndDateBatch(itemId);
    }

    @Override
    public CouponBatchDO findAppItemMaxValidEndDateBatch(Long appItemId) {
        return this.couponBatchDao.findAppItemMaxValidEndDateBatch(appItemId);
    }

    @Override
    public int updateActiveAndRemaining(Long id, Integer active, Integer remaining) {
        int ret = this.couponBatchDao.updateActiveAndRemaining(id, active, remaining);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public int updateActive(Long id, Integer active) {
        int ret = this.couponBatchDao.updateActive(id, active);
        this.cacheClient.remove(this.getCacheKeyById(id));
        return ret;
    }

    @Override
    public CouponBatchDO findItemBatchByValidStartDateAndValidEndDate(Long itemId, Date validStartDate, Date validEndDate) {
        return this.couponBatchDao.findItemBatchByValidStartDateAndValidEndDate(itemId, validStartDate, validEndDate);
    }

    @Override
    public CouponBatchDO findAppItemBatchByValidStartDateAndValidEndDate(Long appItemId, Date validStartDate, Date validEndDate) {
        return this.couponBatchDao.findAppItemBatchByValidStartDateAndValidEndDate(appItemId, validStartDate, validEndDate);
    }

    @Override
    public CouponBatchDO findLastBatchByItemId(Long itemId) {
        return this.couponBatchDao.findLastBatchByItemId(itemId);
    }

    @Override
    public List<CouponBatchDO> findAllBatch(Long appItemId, Long itemId, String valid) {
        return this.couponBatchDao.findAllBatch(appItemId, itemId, valid);
    }

    @Override
    public void updateAllNewOverDueBatch() {
        List<Long> ids = this.couponBatchDao.selectIdsOfNewOverDueBatch();
        this.couponBatchDao.updateAllNewOverDueBatch();
        for (Long id : ids) {
            this.cacheClient.remove(this.getCacheKeyById(id));
        }
    }

    @Override
    public void setItemBatchEmpty(Long itemId) {
        this.couponBatchDao.setItemBatchEmpty(itemId);
    }

    @Override
    public void setAppItemBatchEmpty(Long appItemId) {
        this.couponBatchDao.setAppItemBatchEmpty(appItemId);
    }

    @Override
    public CouponBatchDO findBatchByValidEndDate(Long appItemId, Long itemId, Date validEndDate) {
        return this.couponBatchDao.findBatchByValidEndDate(appItemId, itemId, validEndDate);
    }

    @Override
    public CouponBatchDO findBatchByValidStartDateAndValidEndDate(Long appItemId, Long itemId, Date validStartDate, Date validEndDate) {
        return this.couponBatchDao.findBatchByValidStartDateAndValidEndDate(appItemId, itemId, validStartDate, validEndDate);
    }

    @Override
    public Date getMaxValidEndDate(Long appItemId, Long itemId) {
        return this.couponBatchDao.getMaxValidEndDate(appItemId, itemId);
    }

    @Override
    public Date getMinValidEndDate(Long appItemId, Long itemId) {
        return this.couponBatchDao.getMinValidEndDate(appItemId, itemId);
    }

    @Override
    public Integer countAllRemaining(Long appItemId, Long itemId) {
        return this.couponBatchDao.countAllRemaining(appItemId, itemId);
    }

    @Override
    public Integer deleteBatchRecord(Long batchId) {
        int ret = this.couponBatchDao.deleteBatchRecord(batchId);
        this.cacheClient.remove(this.getCacheKeyById(batchId));
        return ret;
    }

    @Override
    public Integer turnbackCouponBatchRemaining(Long batchId) {
        int ret = this.couponBatchDao.turnbackCouponBatchRemaining(batchId);
        this.cacheClient.remove(this.getCacheKeyById(batchId));
        return ret;
    }

    @Override
    public Integer reduceCouponBatchRemaining(Long batchId) {
        int ret = this.couponBatchDao.reduceCouponBatchRemaining(batchId);
        this.cacheClient.remove(this.getCacheKeyById(batchId));
        return ret;
    }

    @Override
    public Integer countBatchRemaining(Long batchId) {
        return this.couponBatchDao.countBatchRemaining(batchId);
    }

    @Override
    public List<CouponBatchDO> findAllBatchSimple(Long appItemId) {
        return this.couponBatchDao.findAllBatchSimple(appItemId);
    }

    @Override
    public Long findBatchNum(Long appItemId) {
        return this.couponBatchDao.findBatchNum(appItemId);
    }

    @Override
    public List<CouponBatchDO> findBatchInIds(List<Long> ids) {
        return this.couponBatchDao.findBatchInIds(ids);
    }
}

