/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.item.dao.ItemExtraDao;
import cn.com.duiba.service.item.domain.dataobject.ItemExtraDO;
import cn.com.duiba.service.item.service.ItemExtraService;
import cn.com.duiba.wolf.cache.CacheClient;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class ItemExtraServiceImpl
implements ItemExtraService {
    @Resource
    private ItemExtraDao itemExtraDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyByItemId(Long itemId) {
        return "item.itemExtraByItemId_" + itemId;
    }

    @Override
    public ItemExtraDO findByItemId(Long itemId) {
        String key = this.getCacheKeyByItemId(itemId);
        ItemExtraDO d = (ItemExtraDO)this.cacheClient.get(key);
        if (d == null) {
            d = this.itemExtraDao.findByItemId(itemId);
            this.cacheClient.set(key, (Object)d, 300);
        }
        return d;
    }

    @Override
    public List<ItemExtraDO> findByItemIds(List<Long> itemIds) {
        return this.itemExtraDao.findByItemIds(itemIds);
    }

    @Override
    public List<ItemExtraDO> findByName4Admin(String name) {
        return this.itemExtraDao.findByName4Admin(name);
    }

    @Override
    public List<ItemExtraDO> findAll() {
        return this.itemExtraDao.findAll();
    }

    @Override
    public void insert(ItemExtraDO itemExtraDO) {
        this.itemExtraDao.insert(itemExtraDO);
    }

    @Override
    public void update(ItemExtraDO itemExtraDO) {
        ItemExtraDO d = this.itemExtraDao.find(itemExtraDO.getId());
        this.itemExtraDao.update(itemExtraDO);
        this.cacheClient.remove(this.getCacheKeyByItemId(d.getItemId()));
    }
}

