/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dto.SellerDto;
import cn.com.duiba.service.domain.entity.SellerEntity;
import cn.com.duiba.service.item.dao.SellerDao;
import cn.com.duiba.service.item.service.SellerSevice;
import cn.com.duiba.wolf.cache.CacheClient;
import cn.com.duiba.wolf.utils.ObjectUtil;
import cn.com.duiba.wolf.utils.SecurityUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SellerSeviceImpl
implements SellerSevice {
    private static Logger log = LoggerFactory.getLogger(SellerSeviceImpl.class);
    @Autowired
    private SellerDao sellerDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyById(Long id) {
        return "item.sellerId_" + id;
    }

    @Override
    @Transactional(value="credits")
    public Boolean insertSeller(SellerDto sellerDto) {
        SellerEntity sellerEntity = new SellerEntity();
        Boolean flag = true;
        try {
            ObjectUtil.convert((Object)sellerDto, (Object)sellerEntity);
            sellerEntity.setValidFlag(Integer.valueOf(1));
            this.sellerDao.insertSeller(sellerEntity);
            String key = SecurityUtils.encode2StringBySHA((String)(sellerEntity.getId() + new Date().toString()));
            sellerEntity.setSafeSign(key);
            this.sellerDao.update(sellerEntity);
            this.cacheClient.set(this.getCacheKeyById(sellerEntity.getId()), (Object)sellerEntity, 6000);
            log.info("seller key\uff1a" + key);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            flag = false;
        }
        return flag;
    }

    @Override
    public Boolean deleteSeller(Long id) {
        Boolean flag = false;
        int result = this.sellerDao.deleteSeller(id);
        if (result >= 0) {
            this.cacheClient.remove(this.getCacheKeyById(id));
            flag = true;
        }
        return flag;
    }

    @Override
    public List<SellerDto> findAll(SellerDto sellerDto, Integer offset, Integer max) {
        SellerEntity sellerEntity = new SellerEntity();
        ArrayList<SellerDto> sellerDtos = new ArrayList<SellerDto>();
        try {
            ObjectUtil.convert((Object)sellerDto, (Object)sellerEntity);
            List<SellerEntity> sellerEntitys = this.sellerDao.findAll(sellerEntity, offset, max);
            ObjectUtil.convertList(sellerEntitys, sellerDtos, SellerDto.class);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return sellerDtos;
    }

    @Override
    public Integer findCount(SellerDto sellerDto) {
        SellerEntity sellerEntity = new SellerEntity();
        Integer count = 0;
        try {
            ObjectUtil.convert((Object)sellerDto, (Object)sellerEntity);
            count = this.sellerDao.findCount(sellerEntity);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return count;
    }

    @Override
    public SellerDto findById(Long id) {
        SellerDto sellerDto = new SellerDto();
        SellerEntity sellerEntity = null;
        try {
            sellerEntity = (SellerEntity)this.cacheClient.get(this.getCacheKeyById(id));
            if (sellerEntity == null) {
                sellerEntity = this.sellerDao.findById(id);
                this.cacheClient.set(this.getCacheKeyById(id), (Object)sellerEntity, 60);
            }
            ObjectUtil.convert((Object)sellerEntity, (Object)sellerDto);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return sellerDto;
    }
}

