/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.service.item.service.impl;

import cn.com.duiba.service.domain.dataobject.AppItemExtraDO;
import cn.com.duiba.service.item.dao.AppItemExtraDao;
import cn.com.duiba.service.item.service.AppItemExtraService;
import cn.com.duiba.wolf.cache.CacheClient;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AppItemExtraServiceImpl
implements AppItemExtraService {
    @Resource
    private AppItemExtraDao appItemExtraDao;
    @Resource
    private CacheClient cacheClient;

    private String getCacheKeyByAppItemId(Long appItemId) {
        return "item.appItemExtraByAppItemId_" + appItemId;
    }

    @Override
    public AppItemExtraDO findByAppItemId(Long appItemId) {
        if (appItemId != null) {
            String key = this.getCacheKeyByAppItemId(appItemId);
            AppItemExtraDO d = (AppItemExtraDO)this.cacheClient.get(key);
            if (d == null) {
                d = this.appItemExtraDao.findByAppItemId(appItemId);
                this.cacheClient.set(key, (Object)d, 300);
            }
            return d;
        }
        return null;
    }

    @Override
    public void insert(AppItemExtraDO appItemExtra) {
        this.appItemExtraDao.insert(appItemExtra);
    }

    @Override
    public void update(AppItemExtraDO appItemExtra) {
        this.appItemExtraDao.update(appItemExtra);
        this.cacheClient.remove(this.getCacheKeyByAppItemId(appItemExtra.getAppItemId()));
    }

    @Override
    public void insertOrUpdate(AppItemExtraDO appItemExtra) {
        AppItemExtraDO oldAppItemExtra = this.appItemExtraDao.findByAppItemId(appItemExtra.getAppItemId());
        if (oldAppItemExtra == null) {
            this.appItemExtraDao.insert(appItemExtra);
        } else {
            this.update(appItemExtra);
        }
    }

    @Override
    public void deleteByAppItemId(Long appItemId) {
        this.appItemExtraDao.deleteByAppItemId(appItemId);
        this.cacheClient.remove(this.getCacheKeyByAppItemId(appItemId));
    }
}

