/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sms.sdk.service.impl;

import cn.com.duiba.message.service.api.dto.SmsSendInvoiceV2;
import cn.com.duiba.message.service.api.dto.SmsVerificationCodeParam;
import cn.com.duiba.message.service.api.remoteservice.RemoteSmsV2Service;
import cn.com.duiba.sms.sdk.config.DuibaSmsConfig;
import cn.com.duiba.sms.sdk.message.Errors;
import cn.com.duiba.sms.sdk.result.SmsResult;
import cn.com.duiba.sms.sdk.service.SmsV2Service;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsV2ServiceImpl
implements SmsV2Service {
    private static final Logger log = LoggerFactory.getLogger(SmsV2ServiceImpl.class);
    @Resource
    private RemoteSmsV2Service remoteSmsV2Service;
    @Autowired
    private DuibaSmsConfig duibaSmsConfig;

    @Override
    public SmsResult sendVerificationCode(SmsVerificationCodeParam param) {
        SmsResult smsResult;
        try {
            if (null == param.getSignId()) {
                param.setSignId(this.duibaSmsConfig.getSignId());
            }
            SmsSendInvoiceV2 smsSendInvoiceV2 = this.remoteSmsV2Service.sendVerificationCode(this.duibaSmsConfig.getBizKey(), param);
            smsResult = SmsResult.success(null);
            smsResult.setMobile(smsSendInvoiceV2.getMobile());
            smsResult.setDbSmsId(smsSendInvoiceV2.getDbSmsId());
            log.info("smsSendSdk success,mobile:[{}],templateId:[{}]", (Object)param.getMobile(), (Object)param.getTemplateId());
        }
        catch (Exception e) {
            String exception = Optional.ofNullable(e.getMessage()).orElse(Errors.SMS_EXCEPTION.getMsg());
            log.warn("smsSendSdk error,mobile:[{}],templateId:[{}],msg:[{}]", new Object[]{param.getMobile(), param.getTemplateId(), e.getMessage()});
            smsResult = SmsResult.error(Errors.SMS_EXCEPTION.resetMsg(exception));
        }
        return smsResult;
    }
}

