package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineConditionDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineFieldDto;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 规则引擎字段信息服务 ClassName: RemoteEngineFieldService <br/>
 */
@AdvancedFeignClient
public interface RemoteEngineFieldService {

    /**
     * @Description: 分页查询规则引擎字段信息
     * @Param:
     * @return:
     */
    PageResponse<EngineFieldDto> queryPage(String fieldName, Long sceneId, int pageIndex, Integer pageSize);

    /**
     * @Description: 新增规则引擎字段信息
     * @Param:
     * @return:
     */
    Integer save(EngineFieldDto dto);

    /**
     * @Description: 更新规则引擎字段信息
     * @Param:
     * @return:
     */
    Integer update(EngineFieldDto dto);

    /**
     * @Description: 删除规则引擎字段信息
     * @Param:
     * @return:
     */
    Integer delete(EngineFieldDto dto);

    /**
     * @Description: 校验除了当前关联的场景，是否还有重复的字段名称
     * @Param:
     * @return:  ture 重复
     */
    Boolean checkFieldByScene(EngineFieldDto dto);

    /**
     * @Description: 根据场景id查询字段信息
     * @Param:
     * @return:
     */
    List<EngineFieldDto> getFieldBySceneId(Long sceneId);

    /**
     * @Description: 获取所有字段信息
     * @Param:
     * @return:
     */
    List<EngineFieldDto> getAllField();

//    /**
//     * @Description: 根据场景id和字段名称查询字段信息
//     * @Param:
//     * @return:
//     */
//    List<EngineFieldDto> getFieldBySceneIdAndName(Long sceneId, String fieldName);

    /**
     * 根据字段ID查询，字段被调用情况
     * @param fieldId
     * @return
     */
    List<EngineConditionDto> getConditionsByFields(Long fieldId);

}
