package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineConditionDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineRuleLogDto;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.Date;
import java.util.List;

@AdvancedFeignClient
public interface RemoteEngineRuleLogService {

    /**
     * 分页查询规则引擎规则日志信息
     * @param sceneId
     * @param ruleId
     * @param operateType
     * @param pageIndex
     * @param pageSize
     * @return
     */
    PageResponse<EngineRuleLogDto> queryPage(Long sceneId, Long ruleId, Integer operateType, String startTime, String endTime, int pageIndex, Integer pageSize);



    /**
     * 保存规则引擎规则日志信息
     * @param dto
     * @return
     */
    void save(EngineRuleLogDto dto);

    /**
     * 根据id查询规则条件信息
     * @param id
     * @return
     */
    List<EngineConditionDto> getContentById(Long id);

}
