package cn.com.duiba.duiba.stormrage.center.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.activity.StormActivityBlackListDto;
import cn.com.duiba.wolf.entity.PageResponse;

/**
 * 风控活动黑名单服务-面向系统 ClassName: RemoteBlackListService <br/>
 */
@AdvancedFeignClient
public interface RemoteStormActivityBlackListBackendService {

    /**
     * 活动黑名单-查询单条记录详情
     *
     * @param id
     * @return
     */
    StormActivityBlackListDto findById(Long id);


    /**
     * 活动黑名单-删除某条记录
     *
     * @param id
     * @return
     */
    Integer deleteById(Long id);


    /**
     * 活动黑名单-分页查询
     * @param appId
     * @param customerId
     * @param ip
     * @param projectId
     * @param pageNo
     * @param pageSize
     * @return
     */
    PageResponse<StormActivityBlackListDto> queryPage(Long appId, Long customerId, String ip, Long projectId, Integer pageNo, Integer pageSize);

}
