package cn.com.duiba.duiba.stormrage.center.api.remoteservice.risk;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.risk.StormWhiteListDto;
import cn.com.duiba.duiba.stormrage.center.common.param.RiskWhiteListParam;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 风控活动黑名单服务-面向系统 ClassName: RemoteBlackListService <br/>
 */
@AdvancedFeignClient
public interface RemoteStormWhiteListService {

    //新增
    int insert(StormWhiteListDto dto) throws BizException;


    //根据主键修改
    int updateById(StormWhiteListDto dto);

    /**
     * 条件查询list
     *
     * @param param
     * @return
     */
    PageResponse<StormWhiteListDto> listByAppConsumerTypeSences(RiskWhiteListParam param);

    /**
     * 根据主键删除操作
     *
     * @return
     */
    void batchDeleteByPrimaryKey(List<Long> ids);

    /**
     * 批量查询
     *
     * @param appId     appId
     * @param riskType  riskType
     * @param riskScene riskScene
     * @param cid       cid
     * @return
     */
    List<StormWhiteListDto> selectByMultValues(Long appId, Integer riskType, Integer riskScene, List<String> cid);

    /**
     * 查询该ip白名单记录是否已经存在
     *
     * @param riskScene riskScene
     * @param ip        ip
     * @return
     */
    Boolean checkIpExist(Integer riskScene, String ip);

    /**
     * 批量ip白名单插入
     *
     * @param list
     * @return
     */
    int batchIpInsert(List<StormWhiteListDto> list);

    /**
     * 删除ip白名单
     *
     * @param riskScene riskScene
     * @param ip        ip
     * @return
     */
    int deleteIpWhiteList(Integer riskScene, String ip);

}
