package cn.com.duiba.duiba.stormrage.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineConditionDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.EngineFieldDto;
import cn.com.duiba.duiba.stormrage.center.common.dto.UniversalBlacklistDto;
import cn.com.duiba.wolf.entity.PageResponse;

import java.util.List;

/**
 * 通用IP黑名单
 */
@AdvancedFeignClient
public interface RemoteUniversalBlacklistService {

    /**
     * @Description: 分页查询
     * @Param:
     * @return:
     */
    PageResponse<UniversalBlacklistDto> queryPage(String ip, Integer status, int pageIndex, Integer pageSize);

    /**
     * @Description: 新增
     * @Param:
     * @return:
     */
    Integer save(UniversalBlacklistDto dto);

    /**
     * @Description: 更新
     * @Param:
     * @return:
     */
    Integer update(UniversalBlacklistDto dto);

    /**
     * 根据IP获取
     * @param ip
     * @return
     */
    UniversalBlacklistDto getByIp(String ip);

    /**
     * 根据ID获取对象
     * @param id
     * @return
     */
    UniversalBlacklistDto getById(Long id);


    /**
     * @Description: 批量新增
     * @Param:
     * @return:
     */
    Integer batchSave(List<UniversalBlacklistDto> dtos);


    /**
     * @Description: 校验是否存在重复的IP
     * @Param:
     * @return:  ture 重复
     */
    Boolean checkFieldByScene(UniversalBlacklistDto dto);


}
