package cn.com.duiba.duiba.stormrage.center.common.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author chenyongkun
 * @date 2023/2/20
 */
@Data
public class EngineStrategyDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long              id;

    /**
     * 策略标识
     */
    private String strategyKey;

    /**
     * 策略名称
     */
    private String strategyName;

    /**
     * 策略类型
     */
    private Integer strategyType = 0;

    /**
     * 场景ID
     */
    private Long sceneId;

    /**
     * 场景名称
     */
    private String sceneName;

    /**
     * 策略状态
     */
    private Integer strategyStatus;

    /**
     * 策略分数1
     */
    private Double score1;

    /**
     * 策略分数2
     */
    private Double score2;

    /**
     * 策略分数3
     */
    private Double score3;

    /**
     * 策略分数4
     */
    private Double score4;

    /**
     * 描述
     */
    private String description;

    /**
     * 创建者
     */
    private String creator;

    /**
     * 编辑者
     */
    private String editor;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 时效分
     */
    private Double timeScore;

    /**
     * 加入黑名单时间
     */
    private Integer blackDay;
}
