package cn.com.duiba.duiba.stormrage.center.common.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author chenyongkun
 * @date 2023/2/20
 */
@Data
public class EngineFieldDto implements Serializable {

    private static final long serialVersionUID = 1L;

    private Long              id;

    /**
     * 字段名称
     */
    private String            fieldName;

    /**
     * 字段类型: '0' 数值 '1' 字符串
     */
    private String            fieldType;

    /**
     * 描述
     */
    private String            description;

    /**
     * 表名称
     */
    private String            fieldTableName;

    /**
     * 表字段
     */
    private String            fieldTableColumn;

    /**
     * 前端显示所属场景名称
     */
    private List<String> sceneNames;

    /**
     * 创建者
     */
    private String            creator;

    /**
     * 修改者
     */
    private String            editor;

    /**
     * 创建时间
     */
    private Date              gmtCreate;

    /**
     * 修改时间
     */
    private Date              gmtModified;

    /**
     * 页面显示修改时间
     */
    private String            gmtModifiedView;

    /**
     * 前端显示所属场景IDs
     */
    private List<Long> sceneIds;


    /**
     * 已被使用场景IDs
     */
    private List<Long> useSceneIds;
}
