package cn.com.duiba.duiba.stormrage.center.common.dto;

import lombok.Data;

import java.util.Date;

/**
 * 怒风风控路由
 * @author chenyongkun
 * @date 2023/3/14
 */
@Data
public class StormRiskRouteDto {

    /**
     * 主键
     */
    private Long id;

    /**
     * 0 其它,1 星速台活动,2 普通活动
     */
    private Integer bizType;

    /**
     * 怒风风控标签：60000自定义,60001 拉新,60002 促活,60003 留存,60004 积分消耗,60005 游戏,60006 秒杀
     */
    private Integer projectLabel;

    /**
     * 非星速台活动的活动类型
     */
    private Integer activityType;

    /**
     * 项目id:怒风风控标签为 自定义时填写
     */
    private String projectId;

    /**
     * 兑吧应用id
     */
    private Long appId;

    /**
     * 怒风风控主场景: 1 提现,2 参与,3 发奖
     */
    private Integer scene;

    /**
     * 场景标识
     */
    private String sceneIdentity;

    /**
     * 惩罚方式:1 拒绝流程,文案提示
     */
    private Integer punishWay;

    /**
     * 文案
     */
    private String copy;

    /**
     * 修改人
     */
    private String modifier;

    /**
     * 0 未删除, 1 已删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
