package cn.com.duiba.duiba.stormrage.center.common.dto.risk;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author chenyongkun
 * @date 2023/2/20
 */
@Data
public class RiskHitRecordDto implements Serializable {

    private static final long serialVersionUID = 4990471255734851795L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 用户id
     */
    private Long consumerId;

    /**
     * 1 用户名单，2 ip黑名单
     */
    private Integer blacklistType;

    /**
     * 怒风风控场景：1 提现，2 参与，3 发奖，4 兑换，7 助力...
     */
    private Integer riskSence;

    /**
     * IP
     */
    private String ip;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 设备id
     */
    private String deviceId;

    /**
     * 平台标志
     */
    private String platform;

    /**
     * user_agent
     */
    private String ua;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动类型
     */
    private Long activityType;

    /**
     * 提现场景下必填 支付宝账号
     */
    private String alipayAccount;

    /**
     * 提现场景下必填 支付宝姓名
     */
    private String alipayName;

    /**
     * 兑换场景必填-商品长ID
     */
    private Long appItemId;

    /**
     * 助力场景必填-被助力者用户ID
     */
    private Long assistedUserId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

}
