package cn.com.duiba.duiba.stormrage.center.common.dto.risk;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * @author chenyongkun
 * @date 2023/2/20
 */
@Data
public class StormBlackListDto implements Serializable {

    private static final long serialVersionUID = 4990471255734851795L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 1 用户黑名单，2 ip黑名单
     */
    private Integer riskType;

    /**
     * 风控场景：1 提现，2 参与，3 发奖，4兑换
     */
    private Integer riskScene;

    /**
     * 根据类型：用户id或者ip
     */
    private String riskValue;

    /**
     * 修改人
     */
    private String modifier;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 备注
     */
    private String remarks;

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StormBlackListDto that = (StormBlackListDto) o;
        return Objects.equals(appId, that.appId) &&
                Objects.equals(riskType, that.riskType) &&
                Objects.equals(riskScene, that.riskScene) &&
                Objects.equals(riskValue, that.riskValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, riskType, riskScene, riskValue);
    }
}
