/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.duixintong.center.api.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final SimpleDateFormat ONLY_MONTH = DateUtils.getFormat("MM");
    private static final SimpleDateFormat ONLY_DAY = DateUtils.getFormat("dd");
    private static final SimpleDateFormat ONLY_HOUR = DateUtils.getFormat("HH");
    private static final SimpleDateFormat LONG_MONTH = DateUtils.getFormat("yyyyMM");
    private static final SimpleDateFormat LONG_DAY = DateUtils.getFormat("yyyyMMdd");
    private static final SimpleDateFormat LONG_HOUR = DateUtils.getFormat("yyyyMMddHH");

    private static SimpleDateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    private static String getStr(Date date, SimpleDateFormat format) {
        if (date == null) {
            return "";
        }
        return format.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOnlyHourStr(Date date) {
        SimpleDateFormat simpleDateFormat = ONLY_HOUR;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, ONLY_HOUR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOnlyDayStr(Date date) {
        SimpleDateFormat simpleDateFormat = ONLY_DAY;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, ONLY_DAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOnlyMonthStr(Date date) {
        SimpleDateFormat simpleDateFormat = ONLY_MONTH;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, ONLY_MONTH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLongHourStr(Date date) {
        SimpleDateFormat simpleDateFormat = LONG_HOUR;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, LONG_HOUR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLongDayStr(Date date) {
        SimpleDateFormat simpleDateFormat = LONG_DAY;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, LONG_DAY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLongMonthStr(Date date) {
        SimpleDateFormat simpleDateFormat = LONG_MONTH;
        synchronized (simpleDateFormat) {
            return DateUtils.getStr(date, LONG_MONTH);
        }
    }

    public static Date getEndDayOfMonth() {
        Calendar cale = Calendar.getInstance();
        cale.add(2, 1);
        cale.set(5, 0);
        cale.set(11, 23);
        cale.set(12, 59);
        cale.set(13, 59);
        return cale.getTime();
    }
}

